/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Cast;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.StyledDescriber;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.TreeFormatter;

public class AmbiguousConfigurationSelectionException
extends StyledException {
    public AmbiguousConfigurationSelectionException(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveMetadata> matches, ComponentGraphResolveMetadata targetComponent, boolean variantAware, Set<VariantGraphResolveMetadata> discarded) {
        super(AmbiguousConfigurationSelectionException.generateMessage(new StyledDescriber(describer), fromConfigurationAttributes, attributeMatcher, matches, discarded, targetComponent, variantAware));
    }

    private static String generateMessage(AttributeDescriber describer, AttributeContainerInternal fromConfigurationAttributes, AttributeMatcher attributeMatcher, List<? extends VariantGraphResolveMetadata> matches, Set<VariantGraphResolveMetadata> discarded, ComponentGraphResolveMetadata targetComponent, boolean variantAware) {
        String string;
        TreeMap<String, VariantGraphResolveMetadata> ambiguousVariants = new TreeMap<String, VariantGraphResolveMetadata>();
        for (VariantGraphResolveMetadata variantGraphResolveMetadata : matches) {
            ambiguousVariants.put(variantGraphResolveMetadata.getName(), variantGraphResolveMetadata);
        }
        TreeFormatter formatter = new TreeFormatter();
        String string2 = string = variantAware ? "variants" : "configurations";
        if (fromConfigurationAttributes.isEmpty()) {
            formatter.node("Cannot choose between the following " + string + " of ");
        } else {
            formatter.node("The consumer was configured to find " + describer.describeAttributeSet(fromConfigurationAttributes.asMap()) + ". However we cannot choose between the following " + string + " of ");
        }
        formatter.append((CharSequence)AmbiguousConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.Info, (String)targetComponent.getId().getDisplayName()));
        formatter.startChildren();
        for (String configuration : ambiguousVariants.keySet()) {
            formatter.node(configuration);
        }
        formatter.endChildren();
        formatter.node("All of them match the consumer attributes");
        formatter.startChildren();
        for (VariantGraphResolveMetadata ambiguousVariant : ambiguousVariants.values()) {
            AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, ambiguousVariant, variantAware, true, describer);
        }
        formatter.endChildren();
        if (!discarded.isEmpty()) {
            formatter.node("The following " + string + " were also considered but didn't match the requested attributes:");
            formatter.startChildren();
            discarded.stream().sorted(Comparator.comparing(VariantGraphResolveMetadata::getName)).forEach(discardedConf -> AmbiguousConfigurationSelectionException.formatConfiguration(formatter, targetComponent, fromConfigurationAttributes, attributeMatcher, discardedConf, variantAware, false, describer));
            formatter.endChildren();
        }
        return formatter.toString();
    }

    static void formatConfiguration(TreeFormatter formatter, ComponentGraphResolveMetadata targetComponent, AttributeContainerInternal consumerAttributes, AttributeMatcher attributeMatcher, VariantGraphResolveMetadata variant, boolean variantAware, boolean ambiguous, AttributeDescriber describer) {
        ImmutableAttributes producerAttributes = variant.getAttributes();
        if (variantAware) {
            formatter.node("Variant '");
        } else {
            formatter.node("Configuration '");
        }
        formatter.append((CharSequence)variant.getName());
        formatter.append((CharSequence)"'");
        if (variantAware) {
            formatter.append((CharSequence)(" " + CapabilitiesSupport.prettifyCapabilities(targetComponent, variant.getCapabilities().getCapabilities())));
        }
        if (ambiguous) {
            AmbiguousConfigurationSelectionException.formatAttributeMatchesForAmbiguity(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        } else {
            AmbiguousConfigurationSelectionException.formatAttributeMatchesForIncompatibility(formatter, consumerAttributes.asImmutable(), attributeMatcher, producerAttributes.asImmutable(), describer);
        }
    }

    static void formatAttributeMatchesForIncompatibility(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = AmbiguousConfigurationSelectionException.collectAttributes(immutableConsumer, immutableProducer);
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        LinkedHashMap compatibleAttrs = Maps.newLinkedHashMap();
        LinkedHashMap incompatibleAttrs = Maps.newLinkedHashMap();
        LinkedHashMap incompatibleConsumerAttrs = Maps.newLinkedHashMap();
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) {
                    compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                    continue;
                }
                incompatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                incompatibleConsumerAttrs.put(attribute, Cast.uncheckedCast((Object)consumerValue.get()));
                continue;
            }
            if (!consumerValue.isPresent()) continue;
            otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)AmbiguousConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet((Map)compatibleAttrs)));
        }
        formatter.startChildren();
        if (!incompatibleAttrs.isEmpty()) {
            formatter.node("Incompatible because this component declares " + AmbiguousConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.FailureHeader, (String)describer.describeAttributeSet((Map)incompatibleAttrs)) + " and the consumer needed <FailureHeader>" + describer.describeAttributeSet((Map)incompatibleConsumerAttrs) + "</FailureHeader>");
        }
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Other compatible attribute", otherValues);
        formatter.endChildren();
    }

    static void formatAttributeMatchesForAmbiguity(TreeFormatter formatter, ImmutableAttributes immutableConsumer, AttributeMatcher attributeMatcher, ImmutableAttributes immutableProducer, AttributeDescriber describer) {
        Map<String, Attribute<?>> allAttributes = AmbiguousConfigurationSelectionException.collectAttributes(immutableConsumer, immutableProducer);
        LinkedHashMap compatibleAttrs = Maps.newLinkedHashMap();
        ArrayList otherValues = Lists.newArrayListWithExpectedSize((int)allAttributes.size());
        for (Attribute<?> attribute : allAttributes.values()) {
            Attribute untyped = (Attribute)Cast.uncheckedCast(attribute);
            String attributeName = attribute.getName();
            AttributeValue consumerValue = immutableConsumer.findEntry(untyped);
            AttributeValue producerValue = immutableProducer.findEntry(attributeName);
            if (consumerValue.isPresent() && producerValue.isPresent()) {
                if (!attributeMatcher.isMatching(untyped, producerValue.coerce(attribute), consumerValue.coerce(attribute))) continue;
                compatibleAttrs.put(attribute, Cast.uncheckedCast((Object)producerValue.get()));
                continue;
            }
            if (consumerValue.isPresent()) {
                otherValues.add("Doesn't say anything about " + describer.describeMissingAttribute(attribute, consumerValue.get()));
                continue;
            }
            otherValues.add("Provides " + describer.describeExtraAttribute(attribute, producerValue.get()) + " but the consumer didn't ask for it");
        }
        if (!compatibleAttrs.isEmpty()) {
            formatter.append((CharSequence)" declares ").append((CharSequence)AmbiguousConfigurationSelectionException.style((StyledTextOutput.Style)StyledTextOutput.Style.SuccessHeader, (String)describer.describeAttributeSet((Map)compatibleAttrs)));
        }
        formatter.startChildren();
        AmbiguousConfigurationSelectionException.formatAttributeSection(formatter, "Unmatched attribute", otherValues);
        formatter.endChildren();
    }

    private static Map<String, Attribute<?>> collectAttributes(ImmutableAttributes consumerAttributes, ImmutableAttributes producerAttributes) {
        TreeMap allAttributes = new TreeMap();
        for (Attribute attribute : producerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        for (Attribute attribute : consumerAttributes.keySet()) {
            allAttributes.put(attribute.getName(), attribute);
        }
        return allAttributes;
    }

    private static void formatAttributeSection(TreeFormatter formatter, String section, List<String> values) {
        if (!values.isEmpty()) {
            if (values.size() > 1) {
                formatter.node(section + "s");
            } else {
                formatter.node(section);
            }
            formatter.startChildren();
            values.forEach(arg_0 -> ((TreeFormatter)formatter).node(arg_0));
            formatter.endChildren();
        }
    }
}

