/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.builtins.IrBuiltInsMapGeneratedKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterException;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicEvaluator;
import org.jetbrains.kotlin.ir.interpreter.proxy.ProxyKt;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J,\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u001e\u0010,\u001a\u00020\u00162\u0006\u0010-\u001a\u00020.2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00160%H\u0016J\u0010\u0010/\u001a\u00020\u00162\u0006\u0010-\u001a\u000200H\u0016J,\u00101\u001a\u0004\u0018\u0001022\u0006\u0010\u0017\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\n\u00104\u001a\u0006\u0012\u0002\b\u000305H\u0016J\u0016\u00106\u001a\u00020\u001e*\u0004\u0018\u0001022\u0006\u00107\u001a\u00020\u001eH\u0002J$\u00108\u001a\u00020\u0016*\u0004\u0018\u0001092\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u000e\u0010:\u001a\u0004\u0018\u00010;*\u00020\u0018H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/DefaultCallInterceptor;", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;)V", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "calculateBuiltIns", "", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "args", "", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "calculateRangeTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "handleIntrinsicMethods", "", "interceptCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "defaultAction", "Lkotlin/Function0;", "interceptConstructor", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interceptEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interceptGetObjectValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interceptJavaStaticField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interceptProxy", "", "valueArguments", "expectedResultClass", "Ljava/lang/Class;", "getType", "defaultType", "invokeMethod", "Ljava/lang/invoke/MethodHandle;", "trySubstituteFunctionBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "ir.interpreter"})
public final class DefaultCallInterceptor
implements CallInterceptor {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final CallStack callStack;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;

    public DefaultCallInterceptor(@NotNull IrInterpreter interpreter2) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        this.interpreter = interpreter2;
        this.environment = this.getInterpreter().getEnvironment$ir_interpreter();
        this.callStack = this.getEnvironment().getCallStack$ir_interpreter();
        this.irBuiltIns = this.getEnvironment().getIrBuiltIns();
        this.bodyMap = this.getInterpreter().getBodyMap$ir_interpreter();
    }

    @Override
    @NotNull
    public IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    @NotNull
    public IrInterpreterEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @Override
    @Nullable
    public Object interceptProxy(@NotNull IrFunction irFunction2, @NotNull List<? extends State> valueArguments, @NotNull Class<?> expectedResultClass) {
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(valueArguments, (String)"valueArguments");
        Intrinsics.checkNotNullParameter(expectedResultClass, (String)"expectedResultClass");
        IrCall irCall = IrTreeBuildUtilsKt.createCall$default(irFunction2, null, 1, null);
        return ProxyKt.wrap(this.getInterpreter().withNewCallStack$ir_interpreter(irCall, (Function1<? super IrInterpreter, ? extends Object>)((Function1)new Function1<IrInterpreter, Unit>(irCall, valueArguments){
            final /* synthetic */ IrCall $irCall;
            final /* synthetic */ List<State> $valueArguments;
            {
                this.$irCall = $irCall;
                this.$valueArguments = $valueArguments;
                super(1);
            }

            public final void invoke(@NotNull IrInterpreter $this$withNewCallStack) {
                Intrinsics.checkNotNullParameter((Object)$this$withNewCallStack, (String)"$this$withNewCallStack");
                InstructionKt.pushSimpleInstruction($this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter(), this.$irCall);
                Iterable $this$forEach$iv = this.$valueArguments;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    State it = (State)element$iv;
                    boolean bl = false;
                    $this$withNewCallStack.getEnvironment$ir_interpreter().getCallStack$ir_interpreter().pushState(it);
                }
            }
        })), (CallInterceptor)this, false, expectedResultClass);
    }

    @Override
    public void interceptCall(@NotNull IrCall call2, @NotNull IrFunction irFunction2, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        boolean isInlineOnly = IrUtilsKt.hasAnnotation((IrAnnotationContainer)irFunction2, new FqName("kotlin.internal.InlineOnly"));
        boolean isSyntheticDefault = Intrinsics.areEqual((Object)irFunction2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE);
        State receiver = irFunction2.getDispatchReceiverParameter() != null ? args.get(0) : null;
        if (receiver instanceof Wrapper && !isInlineOnly && !isSyntheticDefault) {
            this.invokeMethod(((Wrapper)receiver).getMethod(irFunction2), irFunction2, args);
        } else if (Wrapper.Companion.mustBeHandledWithWrapper(irFunction2)) {
            this.invokeMethod(Wrapper.Companion.getStaticMethod(irFunction2), irFunction2, args);
        } else {
            if (this.handleIntrinsicMethods(irFunction2)) {
                return;
            }
            if (StateKt.mustBeHandledAsReflection(receiver, call2)) {
                this.invokeMethod(Wrapper.Companion.getReflectionMethod(irFunction2), irFunction2, args);
            } else if (receiver instanceof Primitive) {
                this.calculateBuiltIns(irFunction2, args);
            } else if (irFunction2.getBody() == null && UtilsKt.isAccessorOfPropertyWithBackingField(irFunction2)) {
                InstructionKt.pushCompoundInstruction(this.callStack, IrTreeBuildUtilsKt.createGetField(irFunction2));
            } else if (irFunction2.getBody() == null) {
                IrElement irElement = this.trySubstituteFunctionBody(irFunction2);
                if (irElement == null) {
                    this.calculateBuiltIns(irFunction2, args);
                    irElement = Unit.INSTANCE;
                }
            } else {
                defaultAction.invoke();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void interceptConstructor(@NotNull IrFunctionAccessExpression constructorCall, @NotNull List<? extends State> args, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)constructorCall, (String)"constructorCall");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        State receiver = this.callStack.loadState(UtilsKt.getThisReceiver(constructorCall));
        IrFunction irConstructor2 = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        IrClass irClass2 = IrUtilsKt.getParentAsClass(irConstructor2);
        if (Wrapper.Companion.mustBeHandledWithWrapper(irClass2)) {
            this.invokeMethod(Wrapper.Companion.getConstructorMethod(irConstructor2), irConstructor2, args);
            if (UtilsKt.isSubclassOfThrowable(irClass2)) {
                Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.ExceptionState");
                ExceptionState exceptionState = (ExceptionState)receiver;
                State state = this.callStack.popState();
                Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                exceptionState.copyFieldsFrom((Wrapper)state);
            } else if (constructorCall instanceof IrConstructorCall) {
                this.callStack.rewriteState(UtilsKt.getThisReceiver(constructorCall), this.callStack.popState());
            } else {
                Intrinsics.checkNotNull((Object)receiver, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
                Complex complex = (Complex)receiver;
                State state = this.callStack.popState();
                Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Wrapper");
                complex.setSuperWrapperClass((Wrapper)state);
            }
        } else if (IrTypePredicatesKt.isArray(IrUtilsKt.getDefaultType(irClass2)) || UtilsKt.isPrimitiveArray(IrUtilsKt.getDefaultType(irClass2))) {
            boolean value$iv = this.handleIntrinsicMethods(irConstructor2);
            boolean $i$f$verify = false;
            if (!value$iv) {
                boolean bl = false;
                String string2 = ("Unsupported intrinsic constructor: " + RenderIrElementKt.render(irConstructor2)).toString();
                throw new InterpreterAssertionError(string2);
            }
        } else if (IrTypePredicatesKt.isUnsignedType$default(IrUtilsKt.getDefaultType(irClass2), false, 1, null)) {
            void $this$interceptConstructor_u24lambda_u2d2;
            State state;
            Iterable $this$single$iv = irClass2.getDeclarations();
            boolean $i$f$single22 = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof IrProperty)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSymbol propertySymbol = ((IrDeclaration)single$iv).getSymbol();
            State $i$f$single22 = state = receiver;
            CallStack callStack = this.callStack;
            boolean bl = false;
            $this$interceptConstructor_u24lambda_u2d2.setField(propertySymbol, (State)CollectionsKt.single(args));
            callStack.pushState(state);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass objectClass = (IrClass)expression2.getSymbol().getOwner();
        if (Wrapper.Companion.mustBeHandledWithWrapper(objectClass)) {
            Wrapper result2 = Wrapper.Companion.getCompanionObject(objectClass, this.getEnvironment());
            this.getEnvironment().getMapOfObjects$ir_interpreter().put(expression2.getSymbol(), result2);
            this.callStack.pushState(result2);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptEnumEntry(@NotNull IrEnumEntry enumEntry, @NotNull Function0<Unit> defaultAction) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter(defaultAction, (String)"defaultAction");
        IrClass enumClass2 = IrUtilsKt.getParentAsClass((IrDeclaration)enumEntry.getSymbol().getOwner());
        if (Wrapper.Companion.mustBeHandledWithWrapper(enumClass2)) {
            State enumEntryName = this.getEnvironment().convertToState$ir_interpreter(enumEntry.getName().asString(), this.getEnvironment().getIrBuiltIns().getStringType());
            Iterable $this$single$iv = enumClass2.getDeclarations();
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)AdditionalIrUtilsKt.getNameForIrSerialization(it).asString(), (Object)"valueOf")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Object v0 = single$iv;
            Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
            IrFunction valueOfFun = v0;
            this.invokeMethod(Wrapper.Companion.getEnumEntry(enumClass2), valueOfFun, CollectionsKt.listOf((Object)enumEntryName));
            Map<IrSymbol, Complex> map = this.getEnvironment().getMapOfEnums$ir_interpreter();
            IrEnumEntrySymbol irEnumEntrySymbol = enumEntry.getSymbol();
            State state = this.callStack.popState();
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            Complex complex = (Complex)state;
            map.put(irEnumEntrySymbol, complex);
        } else {
            defaultAction.invoke();
        }
    }

    @Override
    public void interceptJavaStaticField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field2 = (IrField)expression2.getSymbol().getOwner();
        ExceptionUtilsKt.verify(Intrinsics.areEqual((Object)field2.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE) && field2.isStatic());
        IrExpressionBody irExpressionBody = field2.getInitializer();
        ExceptionUtilsKt.verify(!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst));
        this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(Wrapper.Companion.getStaticGetter(field2).invokeWithArguments(new Object[0]), field2.getType()));
    }

    private final void invokeMethod(MethodHandle $this$invokeMethod, IrFunction irFunction2, List<? extends State> args) {
        if ($this$invokeMethod == null) {
            boolean value$iv = this.handleIntrinsicMethods(irFunction2);
            boolean $i$f$verify = false;
            if (!value$iv) {
                boolean bl = false;
                String string2 = ("Unsupported intrinsic function: " + RenderIrElementKt.render(irFunction2)).toString();
                throw new InterpreterAssertionError(string2);
            }
            return;
        }
        CallInterceptor callInterceptor = this;
        MethodType methodType = $this$invokeMethod.type();
        Intrinsics.checkNotNullExpressionValue((Object)methodType, (String)"this.type()");
        List<Object> argsForMethodInvocation = UtilsKt.getArgsForMethodInvocation(irFunction2, callInterceptor, methodType, args);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            boolean bl = false;
            Object result2 = $this$invokeMethod.invokeWithArguments(argsForMethodInvocation);
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    private final boolean handleIntrinsicMethods(IrFunction irFunction2) {
        List<Instruction> list2 = IntrinsicEvaluator.INSTANCE.unwindInstructions(irFunction2, this.getEnvironment());
        if (list2 == null) {
            return false;
        }
        List<Instruction> instructions = list2;
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction it = (Instruction)element$iv;
            boolean bl = false;
            this.callStack.pushInstruction(it);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateBuiltIns(IrFunction irFunction2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
        IrPropertySymbol property2 = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
        String string2 = property2 == null ? irFunction2.getName().asString() : ((IrProperty)property2.getOwner()).getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (val property = (ir\u2026name.asString()\n        }");
        String methodName = string2;
        IrAnnotationContainer irAnnotationContainer = irFunction2.getDispatchReceiverParameter();
        if (irAnnotationContainer == null || (irAnnotationContainer = irAnnotationContainer.getType()) == null) {
            IrValueParameter irValueParameter = irFunction2.getExtensionReceiverParameter();
            irAnnotationContainer = irValueParameter != null ? irValueParameter.getType() : null;
        }
        IrAnnotationContainer receiverType = irAnnotationContainer;
        Iterable iterable = irFunction2.getValueParameters();
        Collection collection = CollectionsKt.listOfNotNull((Object)receiverType);
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        List argsType = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        List argsValues = ProxyKt.wrap$default(args, (CallInterceptor)this, irFunction2, null, 4, null);
        IrInterpreterEnvironment environment$iv = this.getEnvironment();
        boolean $i$f$withExceptionHandler = false;
        try {
            Object object;
            boolean bl = false;
            switch (argsType.size()) {
                case 1: {
                    object = IrBuiltInsMapGeneratedKt.interpretUnaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), argsValues.get(0));
                    break;
                }
                case 2: {
                    if (Intrinsics.areEqual((Object)methodName, (Object)"rangeTo")) {
                        this.calculateRangeTo(irFunction2.getReturnType(), args);
                        return;
                    }
                    object = IrBuiltInsMapGeneratedKt.interpretBinaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), argsValues.get(0), argsValues.get(1));
                    break;
                }
                case 3: {
                    object = IrBuiltInsMapGeneratedKt.interpretTernaryFunction(methodName, UtilsKt.getOnlyName((IrType)argsType.get(0)), UtilsKt.getOnlyName((IrType)argsType.get(1)), UtilsKt.getOnlyName((IrType)argsType.get(2)), argsValues.get(0), argsValues.get(1), argsValues.get(2));
                    break;
                }
                default: {
                    throw new InterpreterError("Unsupported number of arguments for invocation as builtin function: " + methodName);
                }
            }
            Object result2 = object;
            this.callStack.pushState(this.getEnvironment().convertToState$ir_interpreter(result2, this.getType(result2, irFunction2.getReturnType())));
        }
        catch (InterpreterException e$iv) {
            throw e$iv;
        }
        catch (Throwable e$iv) {
            ExceptionUtilsKt.handleUserException(e$iv, environment$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateRangeTo(IrType type2, List<? extends State> args) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(type2);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        IrConstructor constructor2 = (IrConstructor)SequencesKt.first(IrUtilsKt.getConstructors((IrClass)irClassSymbol.getOwner()));
        IrConstructorCall constructorCall = IrTreeBuildUtilsKt.createConstructorCall$default(constructor2, null, 1, null);
        Iterable $this$map$iv = constructor2.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List constructorValueParameters = (List)destination$iv$iv;
        Iterable $this$map$iv2 = args;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            State bl = (State)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
            collection.add((Primitive)it);
        }
        List primitiveValueParameters = (List)destination$iv$iv2;
        Iterable $this$forEachIndexed$iv = primitiveValueParameters;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void primitive;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (Primitive)item$iv;
            int index2 = n;
            boolean bl = false;
            constructorCall.putValueArgument(index2, IrTreeBuildUtilsKt.toIrConst$default(primitive.getValue(), ((IrValueParameter)((IrValueParameterSymbol)constructorValueParameters.get(index2)).getOwner()).getType(), 0, 0, 6, null));
        }
        InstructionKt.pushCompoundInstruction(this.callStack, constructorCall);
    }

    private final IrType getType(Object $this$getType, IrType defaultType) {
        Object object = $this$getType;
        return object instanceof Boolean ? this.getIrBuiltIns().getBooleanType() : (object instanceof Character ? this.getIrBuiltIns().getCharType() : (object instanceof Byte ? this.getIrBuiltIns().getByteType() : (object instanceof Short ? this.getIrBuiltIns().getShortType() : (object instanceof Integer ? this.getIrBuiltIns().getIntType() : (object instanceof Long ? this.getIrBuiltIns().getLongType() : (object instanceof String ? this.getIrBuiltIns().getStringType() : (object instanceof Float ? this.getIrBuiltIns().getFloatType() : (object instanceof Double ? this.getIrBuiltIns().getDoubleType() : (object == null ? this.getIrBuiltIns().getNothingNType() : defaultType)))))))));
    }

    private final IrElement trySubstituteFunctionBody(IrFunction $this$trySubstituteFunctionBody) {
        IdSignature idSignature = $this$trySubstituteFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return null;
        }
        IdSignature signature2 = idSignature;
        IrBody irBody = this.bodyMap.get(signature2);
        if (irBody == null) {
            return null;
        }
        $this$trySubstituteFunctionBody.setBody(irBody);
        InstructionKt.pushCompoundInstruction(this.callStack, $this$trySubstituteFunctionBody);
        return $this$trySubstituteFunctionBody.getBody();
    }
}

