/*
 * Copyright (C) 2021 Rafał Dzięgiel <rafostar.github@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#if !defined(__GTUBER_INSIDE__) && !defined(GTUBER_COMPILATION)
#error "Only <gtuber/gtuber.h> and <gtuber/gtuber-plugin-devel.h> can be included directly."
#endif

/**
 * SECTION:gtuber-version
 * @title: Gtuber Version
 * @short_description: version checking
 *
 * Gtuber provides macros to check the version of the library at
 * compile-time
 */

/**
 * GTUBER_MAJOR_VERSION:
 *
 * Gtuber major version component
 */
#define GTUBER_MAJOR_VERSION            (0)

/**
 * GTUBER_MINOR_VERSION:
 *
 * Gtuber minor version component
 */
#define GTUBER_MINOR_VERSION            (4)

/**
 * GTUBER_MICRO_VERSION:
 *
 * Gtuber micro version component
 */
#define GTUBER_MICRO_VERSION            (0)

/**
 * GTUBER_VERSION:
 *
 * Gtuber version
 */
#define GTUBER_VERSION                  (0.4.0)

/**
 * GTUBER_VERSION_S:
 *
 * Gtuber version, encoded as a string
 */
#define GTUBER_VERSION_S                  "0.4.0"

#define GTUBER_ENCODE_VERSION(major,minor,micro) \
  ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * GTUBER_VERSION_HEX:
 *
 * Gtuber version, encoded as an hexadecimal number, useful for integer
 * comparisons.
 */
#define GTUBER_VERSION_HEX \
  (GTUBER_ENCODE_VERSION (GTUBER_MAJOR_VERSION, GTUBER_MINOR_VERSION, GTUBER_MICRO_VERSION))

#define GTUBER_CHECK_VERSION(major, minor, micro) \
  (GTUBER_MAJOR_VERSION > (major) || \
   (GTUBER_MAJOR_VERSION == (major) && GTUBER_MINOR_VERSION > (minor)) || \
   (GTUBER_MAJOR_VERSION == (major) && GTUBER_MINOR_VERSION == (minor) && \
    GTUBER_MICRO_VERSION >= (micro)))
