#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson-pretty
version:              0.8.10
visibility:           public
id:                   aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
key:                  aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
license:              BSD-3-Clause
copyright:            Copyright 2011 Falko Peters
maintainer:           Martijn Bastiaan <martijn@hmbastiaan.nl>
author:               Falko Peters <falko.peters@gmail.com>
stability:            experimental
homepage:             http://github.com/informatikr/aeson-pretty
synopsis:             JSON pretty-printing library and command-line tool.
description:
    A JSON pretty-printing library compatible with aeson as well as
    a command-line tool to improve readabilty of streams of JSON data.

    The /library/ provides the function "encodePretty". It is a drop-in
    replacement for aeson'\''s "encode" function, producing JSON-ByteStrings for
    human readers.

    The /command-line tool/ reads JSON from stdin and writes prettified JSON
    to stdout. It also offers a complementary "compact"-mode, essentially the
    opposite of pretty-printing. If you specify @-flib-only@ like this

    > cabal install -flib-only aeson-pretty

    the command-line tool will NOT be installed.

category:             Text, Web, JSON, Pretty Printer
abi:                  8f50207e2057bcb658281984f0787d5b
exposed:              True
exposed-modules:      Data.Aeson.Encode.Pretty
import-dirs:          /usr/lib/ghc-9.2.8/site-local/aeson-pretty-0.8.10
library-dirs:         /usr/lib/ghc-9.2.8/site-local/aeson-pretty-0.8.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson-pretty
hs-libraries:         HSaeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd bytestring-0.11.4.0
    scientific-0.3.7.0-72r9rPpXaeUjwM4XNBSJR text-1.2.5.0
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:
    /usr/share/doc/haskell-aeson-pretty/html/aeson-pretty.haddock

haddock-html:         /usr/share/doc/haskell-aeson-pretty/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

