#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 async
version:              2.2.5
visibility:           public
id:                   async-2.2.5-L1pFc6v09ikFDHHjgXlurp
key:                  async-2.2.5-L1pFc6v09ikFDHHjgXlurp
license:              BSD-3-Clause
copyright:            (c) Simon Marlow 2012
maintainer:           Simon Marlow <marlowsd@gmail.com>
author:               Simon Marlow
homepage:             https://github.com/simonmar/async
synopsis:             Run IO operations asynchronously and wait for their results
description:
    This package provides a higher-level interface over
    threads, in which an @Async a@ is a concurrent
    thread that will eventually deliver a value of
    type @a@.  The package provides ways to create
    @Async@ computations, wait for their results, and
    cancel them.

    Using @Async@ is safer than using threads in two
    ways:

    * When waiting for a thread to return a result,
    if the thread dies with an exception then the
    caller must either re-throw the exception
    ('\''wait'\'') or handle it ('\''waitCatch'\''); the
    exception cannot be ignored.

    * The API makes it possible to build a tree of
    threads that are automatically killed when
    their parent dies (see '\''withAsync'\'').

category:             Concurrency
abi:                  ecaafa27f6bfdfdd28045458787f33af
exposed:              True
exposed-modules:
    Control.Concurrent.Async Control.Concurrent.Async.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/async-2.2.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/async-2.2.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-async
hs-libraries:         HSasync-2.2.5-L1pFc6v09ikFDHHjgXlurp
depends:
    base-4.16.4.0 hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt stm-2.5.0.2

haddock-interfaces:   /usr/share/doc/haskell-async/html/async.haddock
haddock-html:         /usr/share/doc/haskell-async/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

