#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 bitvec
version:              1.1.3.0
visibility:           public
id:                   bitvec-1.1.3.0-BBuhrSfTKrV3K2o2aMlly6
key:                  bitvec-1.1.3.0-BBuhrSfTKrV3K2o2aMlly6
license:              BSD-3-Clause
copyright:            2019-2022 Andrew Lelechenko, 2012-2016 James Cook
maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:
    Andrew Lelechenko <andrew.lelechenko@gmail.com>,
    James Cook <mokus@deepbondi.net>

homepage:             https://github.com/Bodigrim/bitvec
synopsis:             Space-efficient bit vectors
description:
    A newtype over '\''Bool'\'' with a better '\''Vector'\'' instance: 8x less memory, up to 1000x faster.

    The <https://hackage.haskell.org/package/vector vector>
    package represents unboxed arrays of '\''Bool'\''s
    spending 1 byte (8 bits) per boolean.
    This library provides a newtype wrapper '\''Bit'\'' and a custom instance
    of an unboxed '\''Vector'\'', which packs bits densely,
    achieving an __8x smaller memory footprint.__
    The performance stays mostly the same;
    the most significant degradation happens for random writes
    (up to 10% slower).
    On the other hand, for certain bulk bit operations
    '\''Vector'\'' '\''Bit'\'' is up to 1000x faster than '\''Vector'\'' '\''Bool'\''.

    === Thread safety

    * "Data.Bit" is faster, but writes and flips are thread-unsafe.
    This is because naive updates are not atomic:
    they read the whole word from memory,
    then modify a bit, then write the whole word back.
    * "Data.Bit.ThreadSafe" is slower (up to 20%),
    but writes and flips are thread-safe.

    === Similar packages

    * <https://hackage.haskell.org/package/bv bv> and
    <https://hackage.haskell.org/package/bv-little bv-little>
    do not offer mutable vectors.

    * <https://hackage.haskell.org/package/array array>
    is memory-efficient for '\''Bool'\'', but lacks
    a handy '\''Vector'\'' interface and is not thread-safe.

category:             Data, Bit Vectors
abi:                  7d26199d43b0a85ce5dfe5dca1d21a96
exposed:              True
exposed-modules:      Data.Bit Data.Bit.ThreadSafe
hidden-modules:
    Data.Bit.F2Poly Data.Bit.F2PolyTS Data.Bit.Gmp Data.Bit.Immutable
    Data.Bit.ImmutableTS Data.Bit.Internal Data.Bit.InternalTS
    Data.Bit.Mutable Data.Bit.MutableTS Data.Bit.PdepPext
    Data.Bit.Utils

import-dirs:          /usr/lib/ghc-9.2.8/site-local/bitvec-1.1.3.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/bitvec-1.1.3.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bitvec
hs-libraries:         HSbitvec-1.1.3.0-BBuhrSfTKrV3K2o2aMlly6
extra-libraries:      gmp
depends:
    base-4.16.4.0 bytestring-0.11.4.0 deepseq-1.4.6.1 ghc-bignum-1.2
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-bitvec/html/bitvec.haddock
haddock-html:         /usr/share/doc/haskell-bitvec/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

