#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 chell
version:              0.5.0.1
visibility:           public
id:                   chell-0.5.0.1-1Qn5w1bPAXZCSQ3mroJ5fd
key:                  chell-0.5.0.1-1Qn5w1bPAXZCSQ3mroJ5fd
license:              MIT
maintainer:           Chris Martin, Julie Moronuki
author:               John Millikin <john@john-millikin.com>
homepage:             https://github.com/typeclasses/chell
synopsis:             A simple and intuitive library for automated testing.
description:
    Chell is a simple and intuitive library for automated testing. It natively
    supports assertion-based testing, and can use companion libraries
    such as @chell-quickcheck@ to support more complex testing strategies.

    An example test suite, which verifies the behavior of arithmetic operators.

    @
    &#x7b;-\# LANGUAGE TemplateHaskell \#-&#x7d;

    import Test.Chell

    tests_Math :: Suite
    tests_Math = suite \"math\"
    &#x20;   [ test_Addition
    &#x20;   , test_Subtraction
    &#x20;   ]

    test_Addition :: Test
    test_Addition = assertions \"addition\" $ do
    &#x20;   $expect (equal (2 + 1) 3)
    &#x20;   $expect (equal (1 + 2) 3)

    test_Subtraction :: Test
    test_Subtraction = assertions \"subtraction\" $ do
    &#x20;   $expect (equal (2 - 1) 1)
    &#x20;   $expect (equal (1 - 2) (-1))

    main :: IO ()
    main = defaultMain [tests_Math]
    @

    @
    $ ghc --make chell-example.hs
    $ ./chell-example
    PASS: 2 tests run, 2 tests passed
    @

category:             Testing
abi:                  9643cbd07195afd34a53ae8819d25763
exposed:              True
exposed-modules:      Test.Chell
hidden-modules:       Test.Chell.Main Test.Chell.Output Test.Chell.Types
import-dirs:          /usr/lib/ghc-9.2.8/site-local/chell-0.5.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/chell-0.5.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chell
hs-libraries:         HSchell-0.5.0.1-1Qn5w1bPAXZCSQ3mroJ5fd
depends:
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK base-4.16.4.0
    bytestring-0.11.4.0 options-1.2.1.1-2n2ES9q9rSy549AQEiJWbm
    patience-0.3-5ZHwccvCPDg8zBxzllTHqS
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH template-haskell-2.18.0.0
    text-1.2.5.0 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-chell/html/chell.haddock
haddock-html:         /usr/share/doc/haskell-chell/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

