#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.14.3
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.14.3-603icw7ZfWk6nfByeInxdT-haskell-ci-internal

key:
    haskell-ci-0.14.3-603icw7ZfWk6nfByeInxdT-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  2a6561d7572b68794958d95a17cfeab8
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cli HaskellCI.Compiler
    HaskellCI.Config HaskellCI.Config.ConstraintSet
    HaskellCI.Config.CopyFields HaskellCI.Config.Docspec
    HaskellCI.Config.Doctest HaskellCI.Config.Dump
    HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.GitConfig
    HaskellCI.GitHub HaskellCI.GitHub.Yaml HaskellCI.HeadHackage
    HaskellCI.Jobs HaskellCI.List HaskellCI.MonadErr HaskellCI.Newtypes
    HaskellCI.OptionsGrammar HaskellCI.OptparseGrammar
    HaskellCI.Package HaskellCI.ParsecUtils HaskellCI.Prelude
    HaskellCI.Sh HaskellCI.ShVersionRange HaskellCI.TestedWith
    HaskellCI.Tools HaskellCI.Travis HaskellCI.Travis.Yaml
    HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.2.8/site-local/haskell-ci-0.14.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/haskell-ci-0.14.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.14.3-603icw7ZfWk6nfByeInxdT-haskell-ci-internal

depends:
    Cabal-3.6.3.0 HsYAML-0.2.1.3-4elbIHqqq6s4GR2hd5PRf9
    ShellCheck-0.10.0-GULKWZSroD6vmOkqRX9rm
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd
    base16-bytestring-1.0.2.0-2zrcaj2dASWLOg7ed8DTQL binary-0.8.9.0
    bytestring-0.11.4.0
    cabal-install-parsers-0.4.5-DC87gI0LMOB6yeCuicVFVH
    containers-0.6.5.1
    cryptohash-sha256-0.11.102.1-371Jt5DwAMz5e6UHJQG3Qm deepseq-1.4.6.1
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2
    generic-lens-lite-0.1-CqwlLoHGC451vKrr818sCb
    indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
    indexed-traversable-instances-0.1.1.2-1Fjq2phzgHUHDJ57Bb8XWq
    ini-0.4.2-7WotWvHnirnIQKlneFEVZA
    lattices-2.1-9Nitx62bW1Q6UIukt3uRWK mtl-2.2.2
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    optparse-applicative-0.17.1.0-Jx8WaQbsFK9BJBRr9ePa2T
    parsec-3.1.15.0 pretty-1.1.3.6 process-1.6.16.0
    temporary-1.3-ATBZpgmb4kkJvnIbOIhyK2 text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    zinza-0.2-JAecU40EUIv38LvrCc8lcz

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

