#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 conduit
version:              1.3.5
visibility:           public
id:                   conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
key:                  conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
homepage:             http://github.com/snoyberg/conduit
synopsis:             Streaming data processing library.
description:
    `conduit` is a solution to the streaming data problem, allowing for production,
    transformation, and consumption of streams of data in constant memory. It is an
    alternative to lazy I\/O which guarantees deterministic resource handling.

    For more information about conduit in general, and how this package in
    particular fits into the ecosystem, see [the conduit
    homepage](https://github.com/snoyberg/conduit#readme).

    Hackage documentation generation is not reliable. For up to date documentation, please see: <http://www.stackage.org/package/conduit>.

category:             Data, Conduit
abi:                  5a59508cf690d05557c478348732c093
exposed:              True
exposed-modules:
    Conduit Data.Conduit Data.Conduit.Combinators
    Data.Conduit.Combinators.Stream Data.Conduit.Internal
    Data.Conduit.Internal.Fusion Data.Conduit.Internal.List.Stream
    Data.Conduit.Lift Data.Conduit.List

hidden-modules:
    Data.Conduit.Internal.Pipe Data.Conduit.Internal.Conduit
    Data.Conduit.Combinators.Unqualified Data.Streaming.FileRead
    Data.Streaming.Filesystem

import-dirs:          /usr/lib/ghc-9.2.8/site-local/conduit-1.3.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/conduit-1.3.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-conduit
hs-libraries:         HSconduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
depends:
    base-4.16.4.0 bytestring-0.11.4.0 directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.2
    mono-traversable-1.0.17.0-FV8b1TaCW5hJVLcF8mjlSQ mtl-2.2.2
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    resourcet-1.2.6-AkuAfAqfUrLC3kiGqtKSRc text-1.2.5.0
    transformers-0.5.6.2 unix-2.7.2.2
    unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-conduit/html/conduit.haddock
haddock-html:         /usr/share/doc/haskell-conduit/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

