#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 config-ini
version:              0.2.6.0
visibility:           public
id:                   config-ini-0.2.6.0-4l3GSYAqsYGIXTvWAyhmMh
key:                  config-ini-0.2.6.0-4l3GSYAqsYGIXTvWAyhmMh
license:              BSD-3-Clause
copyright:            ©2018 Getty Ritter
maintainer:           Getty Ritter <config-ini@infinitenegativeutility.com>
author:               Getty Ritter <config-ini@infinitenegativeutility.com>
homepage:             https://github.com/aisamanra/config-ini
synopsis:             A library for simple INI-based configuration files.
description:
    The @config-ini@ library is a set of small monadic languages
    for writing simple configuration languages with convenient,
    human-readable error messages.

    > parseConfig :: IniParser (Text, Int, Bool)
    > parseConfig = section "NETWORK" $ do
    >   user <- field        "user"
    >   port <- fieldOf      "port" number
    >   enc  <- fieldFlagDef "encryption" True
    >   return (user, port, enc)

category:             Configuration
abi:                  219496a3aad2afe17ef40ba70e31b0e7
exposed:              True
exposed-modules:
    Data.Ini.Config Data.Ini.Config.Bidir Data.Ini.Config.Raw

import-dirs:          /usr/lib/ghc-9.2.8/site-local/config-ini-0.2.6.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/config-ini-0.2.6.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-config-ini
hs-libraries:         HSconfig-ini-0.2.6.0-4l3GSYAqsYGIXTvWAyhmMh
depends:
    base-4.16.4.0 containers-0.6.5.1
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE text-1.2.5.0
    transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox

haddock-interfaces:   /usr/share/doc/haskell-config-ini/html/config-ini.haddock
haddock-html:         /usr/share/doc/haskell-config-ini/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

