#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-lib
version:              1.32.1
visibility:           public
id:                   hledger-lib-1.32.1-3Fdcz3OVHmX2MyZQsY6iRu
key:                  hledger-lib-1.32.1-3Fdcz3OVHmX2MyZQsY6iRu
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  f3fd743ca4c12347cdc8d5a0128a9a24
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader Hledger.Read.CsvUtils
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-lib-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-lib-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.32.1-3Fdcz3OVHmX2MyZQsY6iRu
depends:
    Decimal-0.5.2-45gqLg1jNnsKjDC17gVM8a
    Glob-0.10.2-IV3EMKztTxU6CHYEAa9DJ0
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK array-0.5.4.0
    base-4.16.4.0 base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd
    blaze-markup-0.8.3.0-FWMMHu9hei31HacT0lMzy9 bytestring-0.11.4.0
    call-stack-0.4.0-7Kj6UtaYY94JDoMxAZHX8y
    cassava-0.5.3.1-2Iv7RuWGQGp84dKhXwCFDJ
    cassava-megaparsec-2.1.1-DUGmPMB4pCiLaaMdYSPl3W
    cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    colour-2.3.6-IwE0zgnqjD2KAyPru21evK containers-0.6.5.1
    data-default-0.7.1.1-LSJh75QrCu1H2SWBLBb1YB deepseq-1.4.6.1
    directory-1.3.6.2 doclayout-0.4.0.1-CFs2Hx2ZHTL3OIftmkEiGR
    extra-1.7.15-A8zqWgaXJf2DqWdsYYbB9w
    file-embed-0.0.15.0-4hNEx1vJ7JTC58fR03LKND filepath-1.4.2.2
    hashtables-1.3.1-Hmnbuv6HqNA8NY0t6CS25T
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA
    microlens-th-0.4.3.15-BttKu46tg2TPgxEFeI4m6 mtl-2.2.2
    pager-0.1.1.0-7fSlqHfRWoLCJKdvb6LPlW
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    pretty-simple-4.1.2.0-Kln7lmU7uGKHkV4FWTYrfF
    regex-tdfa-1.3.2.2-Js34ukrBSX51v3nGkmx3s
    safe-0.3.21-CqIHKdkgiB2klcxc5dxay
    tabular-0.2.2.8-95p3h1QIWwyCocci2BuF7w
    tasty-1.4.3-B04wakHanaTFmtNBHSmYAO
    tasty-hunit-0.10.1-5fDJ2Df2rqV2g8XatY0r3A template-haskell-2.18.0.0
    terminal-size-0.3.4-7GJNKkuDjwr8c9rYP2Bu9E text-1.2.5.0
    text-ansi-0.2.1.1-EZ03XoLJHB78JLu9zQDcJq time-1.11.1.1
    timeit-2.0-FPerWVMxZElJkpHtTsXEJ4 transformers-0.5.6.2
    uglymemo-0.1.0.1-8CUhCtOyIfIKj16OA2DPKD
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

