#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-9ElwuG7xIS0CBumaP3cj7K
key:                  hOpenPGP-2.9.8-9ElwuG7xIS0CBumaP3cj7K
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  3f1fe9d2860e74ba348c61028ed38eea
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-9ElwuG7xIS0CBumaP3cj7K
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    asn1-encoding-0.9.6-2UcDcF1jcVpHjyEfcYb9vi
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    base16-bytestring-1.0.2.0-2zrcaj2dASWLOg7ed8DTQL
    bifunctors-5.6-C3krR03Vy34Eh0jnv6kpRk binary-0.8.9.0
    binary-conduit-1.3.1-3j6KANqN0uzGahrbqIT2hY bytestring-0.11.4.0
    bz2-1.0.1.1-F8vGe1vVkZS8yNEL8EMG93
    conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
    conduit-extra-1.3.6-AphCoy0M4zlHtSPxz4pMHB containers-0.6.5.1
    crypto-cipher-types-0.0.9-JlEUy6YMnlQJGxVQmgyp8z
    cryptonite-0.30-LsRhgAckSKm5u94QG0gjvR
    errors-2.3.0-3H29XYYsfOo5dd0jvIMrGK
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    incremental-parser-0.5.1-BXWKAU063SO14L0GHIKPP1
    ixset-typed-0.5.1.0-KLnMcPce2S3Jhn2EhaV9UX
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    monad-loops-0.4.3-1PoLx7GFY2f6JjKzBe0o6E
    nettle-0.3.1.1-IesfSaYKwdg21K60p9ny7B
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    openpgp-asciiarmor-0.1.2-ICx8sbGIRlR9TAHRuw9d6G
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5
    resourcet-1.2.6-AkuAfAqfUrLC3kiGqtKSRc
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    transformers-0.5.6.2 unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    zlib-0.6.3.0-CkkXEuYiaZzEYzgsgwtii4

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

