#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hslogger
version:              1.3.1.0
visibility:           public
id:                   hslogger-1.3.1.0-LGXq0Irhzb534fxuYt7u8c
key:                  hslogger-1.3.1.0-LGXq0Irhzb534fxuYt7u8c
license:              BSD-3-Clause
copyright:
    Copyright (c) 2004-2018 John Goerzen
    , (c) 2019      Herbert Valerio Riedel

maintainer:           hvr@gnu.org
author:               John Goerzen
homepage:             https://github.com/hvr/hslogger/wiki
synopsis:             Versatile logging framework
description:
    @hslogger@ is a logging framework for Haskell, roughly similar
    to [Python'\''s logging module](https://docs.python.org/2/library/logging.html).

    @hslogger@ lets each log message have a priority and source be associated
    with it.  The programmer can then define global handlers that route
    or filter messages based on the priority and source.  @hslogger@ also
    has a [Syslog](https://tools.ietf.org/html/rfc5424) handler built in.

category:             Interfaces
abi:                  080d6769300dec4c0ec23d340f5faae4
exposed:              True
exposed-modules:
    System.Log System.Log.Formatter System.Log.Handler
    System.Log.Handler.Growl System.Log.Handler.Log4jXML
    System.Log.Handler.Simple System.Log.Handler.Syslog
    System.Log.Logger

hidden-modules:       UTF8
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hslogger-1.3.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hslogger-1.3.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hslogger
hs-libraries:         HShslogger-1.3.1.0-LGXq0Irhzb534fxuYt7u8c
depends:
    base-4.16.4.0 bytestring-0.11.4.0 containers-0.6.5.1
    deepseq-1.4.6.1 network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    network-bsd-2.8.1.0-LOdyT3bHCssArRYM5nM8Kb
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7 time-1.11.1.1
    unix-2.7.2.2

haddock-interfaces:   /usr/share/doc/haskell-hslogger/html/hslogger.haddock
haddock-html:         /usr/share/doc/haskell-hslogger/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

