#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http-media
version:              0.8.1.1
visibility:           public
id:                   http-media-0.8.1.1-1UoBDThrCUL9FeZPpmgYTj
key:                  http-media-0.8.1.1-1UoBDThrCUL9FeZPpmgYTj
license:              MIT
copyright:            (c) 2012-2023 Timothy Jones
maintainer:           Timothy Jones <tim@zmthy.net>
author:               Timothy Jones
homepage:             https://github.com/zmthy/http-media
synopsis:             Processing HTTP Content-Type and Accept headers
description:
    This library is intended to be a comprehensive solution to parsing and
    selecting quality-indexed values in HTTP headers.  It is capable of
    parsing both media types and language parameters from the Accept and
    Content header families, and can be extended to match against other
    accept headers as well.  Selecting the appropriate header value is
    achieved by comparing a list of server options against the
    quality-indexed values supplied by the client.

    In the following example, the Accept header is parsed and then matched
    against a list of server options to serve the appropriate media using
    '\''mapAcceptMedia'\'':

    > getHeader >>= maybe send406Error sendResourceWith . mapAcceptMedia
    >     [ ("text/html",        asHtml)
    >     , ("application/json", asJson)
    >     ]

    Similarly, the Content-Type header can be used to produce a parser for
    request bodies based on the given content type with '\''mapContentMedia'\'':

    > getContentType >>= maybe send415Error readRequestBodyWith . mapContentMedia
    >     [ ("application/json", parseJson)
    >     , ("text/plain",       parseText)
    >     ]

    The API is agnostic to your choice of server.

category:             Web
abi:                  64a159fa32042012cb3619dc70e2c941
exposed:              True
exposed-modules:
    Network.HTTP.Media Network.HTTP.Media.Accept
    Network.HTTP.Media.Charset Network.HTTP.Media.Encoding
    Network.HTTP.Media.Language Network.HTTP.Media.MediaType
    Network.HTTP.Media.RenderHeader

hidden-modules:
    Network.HTTP.Media.Charset.Internal
    Network.HTTP.Media.Encoding.Internal
    Network.HTTP.Media.Language.Internal
    Network.HTTP.Media.MediaType.Internal Network.HTTP.Media.Quality
    Network.HTTP.Media.Utils

import-dirs:          /usr/lib/ghc-9.2.8/site-local/http-media-0.8.1.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/http-media-0.8.1.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-media
hs-libraries:         HShttp-media-0.8.1.1-1UoBDThrCUL9FeZPpmgYTj
depends:
    base-4.16.4.0 bytestring-0.11.4.0
    case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER containers-0.6.5.1
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-http-media/html/http-media.haddock
haddock-html:         /usr/share/doc/haskell-http-media/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

