#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 http2
version:              4.1.0
visibility:           public
id:                   http2-4.1.0-7bviUAvqKtVG3lCpWMiBnk
key:                  http2-4.1.0-7bviUAvqKtVG3lCpWMiBnk
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
homepage:             https://github.com/kazu-yamamoto/http2
synopsis:             HTTP/2 library
description:
    HTTP/2 library including frames, priority queues, HPACK, client and server.

category:             Network
abi:                  2196ecb118bcead0bef4a4d7494390a1
exposed:              True
exposed-modules:
    Network.HPACK Network.HPACK.Internal Network.HPACK.Table
    Network.HPACK.Token Network.HTTP2.Client
    Network.HTTP2.Client.Internal Network.HTTP2.Frame
    Network.HTTP2.Internal Network.HTTP2.Server
    Network.HTTP2.Server.Internal

hidden-modules:
    Imports Network.HPACK.Builder Network.HTTP2.Client.Types
    Network.HTTP2.Client.Run Network.HPACK.HeaderBlock
    Network.HPACK.HeaderBlock.Decode Network.HPACK.HeaderBlock.Encode
    Network.HPACK.HeaderBlock.Integer Network.HPACK.Huffman
    Network.HPACK.Huffman.Bit Network.HPACK.Huffman.ByteString
    Network.HPACK.Huffman.Decode Network.HPACK.Huffman.Encode
    Network.HPACK.Huffman.Params Network.HPACK.Huffman.Table
    Network.HPACK.Huffman.Tree Network.HPACK.Table.Dynamic
    Network.HPACK.Table.Entry Network.HPACK.Table.RevIndex
    Network.HPACK.Table.Static Network.HPACK.Types Network.HTTP2.Arch
    Network.HTTP2.Arch.Cache Network.HTTP2.Arch.Config
    Network.HTTP2.Arch.Context Network.HTTP2.Arch.EncodeFrame
    Network.HTTP2.Arch.File Network.HTTP2.Arch.HPACK
    Network.HTTP2.Arch.Manager Network.HTTP2.Arch.Queue
    Network.HTTP2.Arch.Rate Network.HTTP2.Arch.ReadN
    Network.HTTP2.Arch.Receiver Network.HTTP2.Arch.Sender
    Network.HTTP2.Arch.Status Network.HTTP2.Arch.Stream
    Network.HTTP2.Arch.Types Network.HTTP2.Frame.Decode
    Network.HTTP2.Frame.Encode Network.HTTP2.Frame.Types
    Network.HTTP2.Server.Run Network.HTTP2.Server.Types
    Network.HTTP2.Server.Worker

import-dirs:          /usr/lib/ghc-9.2.8/site-local/http2-4.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/http2-4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http2
hs-libraries:         HShttp2-4.1.0-7bviUAvqKtVG3lCpWMiBnk
depends:
    array-0.5.4.0 async-2.2.5-L1pFc6v09ikFDHHjgXlurp base-4.16.4.0
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    containers-0.6.5.1 http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    network-byte-order-0.1.7-8Wb9MBmdsnYAp65wZlMSzk
    psqueues-0.2.8.0-2OQKJAbUNrl4fTXmy1BF48 stm-2.5.0.2
    time-manager-0.0.1-DQtACCgshbl9lnZaO4ZwkB
    unix-time-0.4.13-6R9aYlAoK65D7gyoK6OwQv
    unliftio-0.2.25.0-INoatlssrBVAcEPI6HA5Cp

haddock-interfaces:   /usr/share/doc/haskell-http2/html/http2.haddock
haddock-html:         /usr/share/doc/haskell-http2/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

