#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hw-fingertree
version:              0.1.2.1
visibility:           public
id:                   hw-fingertree-0.1.2.1-1z6K9fAaXeoCoCJlts7JtU
key:                  hw-fingertree-0.1.2.1-1z6K9fAaXeoCoCJlts7JtU
license:              BSD-3-Clause
copyright:
    (c) 2017-2022 John Ky
    (c) 2006 Ross Paterson, Ralf Hinze,

maintainer:           John Ky <newhoggy@gmail.com>
homepage:             https://github.com/haskell-works/hw-fingertree#readme
synopsis:             Generic finger-tree structure, with example instances
description:
    A general sequence representation with arbitrary
    annotations, for use as a base for implementations of
    various collection types, with examples, as described
    in section 4 of

    * Ralf Hinze and Ross Paterson,
    \"Finger trees: a simple general-purpose data structure\",
    /Journal of Functional Programming/ 16:2 (2006) pp 197-217.
    <http://staff.city.ac.uk/~ross/papers/FingerTree.html>

    For a tuned sequence type, see @Data.Sequence@ in the
    @containers@ package, which is a specialization of
    this structure.

category:             Data Structures
abi:                  372a142abd15fff6edc830ac429d9d03
exposed:              True
exposed-modules:
    HaskellWorks.Data.FingerTree
    HaskellWorks.Data.IntervalMap.FingerTree
    HaskellWorks.Data.PriorityQueue.FingerTree

hidden-modules:       Paths_hw_fingertree
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hw-fingertree-0.1.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hw-fingertree-0.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hw-fingertree
hs-libraries:         HShw-fingertree-0.1.2.1-1z6K9fAaXeoCoCJlts7JtU
depends:
    base-4.16.4.0 deepseq-1.4.6.1
    hw-prim-0.6.3.2-2aClHsKUFSNETfEwgdpTDX

haddock-interfaces:
    /usr/share/doc/haskell-hw-fingertree/html/hw-fingertree.haddock

haddock-html:         /usr/share/doc/haskell-hw-fingertree/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

