#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 indexed-traversable
version:              0.1.3
visibility:           public
id:                   indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
key:                  indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
license:              BSD-2-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Edward Kmett
synopsis:             FunctorWithIndex, FoldableWithIndex, TraversableWithIndex
description:
    This package provides three useful generalizations:

    @
    class Functor f => FunctorWithIndex i f | f -> i where
    \  imap :: (i -> a -> b) -> f a -> f b
    @

    @
    class Foldable f => FoldableWithIndex i f | f -> i where
    \  ifoldMap :: Monoid m => (i -> a -> m) -> f a -> m
    @

    @
    class (FunctorWithIndex i t, FoldableWithIndex i t, Traversable t) => TraversableWithIndex i t | t -> i where
    \  itraverse :: Applicative f => (i -> a -> f b) -> t a -> f (t b)
    @

    This package contains instances for types in GHC boot libraries.
    For some additional instances see [indexed-traversable-instances](https://hackage.haskell.org/package/indexed-traversable-instances).

    The [keys](https://hackage.haskell.org/package/keys) package provides similar functionality,
    but uses (associated) @TypeFamilies@ instead of @FunctionalDependencies@.

category:             Data
abi:                  d14b08be9051fc9e53293f6328d5f58e
exposed:              True
exposed-modules:
    Data.Foldable.WithIndex Data.Foldable1.WithIndex
    Data.Functor.WithIndex Data.Traversable.WithIndex

hidden-modules:       CoerceCompat GhcList WithIndex
import-dirs:          /usr/lib/ghc-9.2.8/site-local/indexed-traversable-0.1.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/indexed-traversable-0.1.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-indexed-traversable
hs-libraries:         HSindexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
depends:
    array-0.5.4.0 base-4.16.4.0 containers-0.6.5.1
    foldable1-classes-compat-0.1-3YpODhjrsnW4sKV6SatlX1
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-indexed-traversable/html/indexed-traversable.haddock

haddock-html:         /usr/share/doc/haskell-indexed-traversable/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

