#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 jose
version:              0.10
visibility:           public
id:                   jose-0.10-JDERold0YQy68PeuqweX29
key:                  jose-0.10-JDERold0YQy68PeuqweX29
license:              Apache-2.0
copyright:            Copyright (C) 2013-2021  Fraser Tweedale
maintainer:           frase@frase.id.au
author:               Fraser Tweedale
homepage:             https://github.com/frasertweedale/hs-jose
synopsis:
    JSON Object Signing and Encryption (JOSE) and JSON Web Token (JWT) library

description:

    Implementation of JSON Object Signing and Encryption
    (JOSE) and JSON Web Token (JWT; RFC 7519).

    The JSON Web Signature (JWS; RFC 7515) implementation is complete.

    EdDSA signatures (RFC 8037) and secp256k1 (RFC 8812) are supported.

    JWK Thumbprint (RFC 7638) is supported.

    JSON Web Encryption (JWE; RFC 7516) is not yet implemented.

    The __ECDSA implementation is vulnerable to timing attacks__ and
    should only be used for verification.

category:             Cryptography
abi:                  55c0423fdb32ae190b174fd7d1799b83
exposed:              True
exposed-modules:
    Crypto.JOSE Crypto.JOSE.AESKW Crypto.JOSE.Compact Crypto.JOSE.Error
    Crypto.JOSE.Header Crypto.JOSE.JWA.JWE Crypto.JOSE.JWA.JWE.Alg
    Crypto.JOSE.JWA.JWK Crypto.JOSE.JWA.JWS Crypto.JOSE.JWE
    Crypto.JOSE.JWK Crypto.JOSE.JWK.Store Crypto.JOSE.JWS
    Crypto.JOSE.Types Crypto.JWT

hidden-modules:
    Crypto.JOSE.TH Crypto.JOSE.Types.Internal Crypto.JOSE.Types.URI

import-dirs:          /usr/lib/ghc-9.2.8/site-local/jose-0.10
library-dirs:         /usr/lib/ghc-9.2.8/site-local/jose-0.10
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-jose
hs-libraries:         HSjose-0.10-JDERold0YQy68PeuqweX29
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI base-4.16.4.0
    base64-bytestring-1.2.1.0-6ICZKEZtNauKUlSfxjYXGw
    bytestring-0.11.4.0 concise-0.1.0.1-6oWpxjnzliKE0TsImLf2LQ
    containers-0.6.5.1 cryptonite-0.30-LsRhgAckSKm5u94QG0gjvR
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    monad-time-0.4.0.0-G0cg84G7v7e4LIba2RkEEW mtl-2.2.2
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    template-haskell-2.18.0.0 text-1.2.5.0 time-1.11.1.1
    x509-1.7.7-DD3wsjhBi2s8azy8w8rWij

haddock-interfaces:   /usr/share/doc/haskell-jose/html/jose.haddock
haddock-html:         /usr/share/doc/haskell-jose/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

