#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 linear-generics
version:              0.2.1
visibility:           public
id:                   linear-generics-0.2.1-8D81N8Lqp4D1Kt3ea4t44S
key:                  linear-generics-0.2.1-8D81N8Lqp4D1Kt3ea4t44S
license:              BSD-3-Clause
copyright:
    2011-2013 Universiteit Utrecht,
    University of Oxford,
    Ryan Scott,
    2021 David Feuer

maintainer:           David.Feuer@gmail.com
author:               José Pedro Magalhães
stability:            experimental
homepage:             https://github.com/linear-generics/linear-generics
synopsis:             Generic programming library for generalised deriving.
description:
    This package offers a version of
    <https://hackage.haskell.org/package/base/docs/GHC-Generics.html GHC.Generics>
    with two important improvements:

    1. The @to@, @from@, @to1@, and @from1@ methods have multiplicity-polymorphic
    types, allowing them to be used with either traditional Haskell code or
    linearly typed code.

    2. The representations used for @Generic1@ are modified slightly. As a result,
    @to1@ and @from1@ never need to use @fmap@. This can
    <https://gitlab.haskell.org/ghc/ghc/-/issues/15969 greatly improve performance>,
    and it is
    <https://github.com/tweag/linear-base/pull/316 necessary to support multiplicity polymorphism>.
    A smaller change, approximately
    <https://gitlab.haskell.org/ghc/ghc/-/issues/7492 as proposed by spl>,
    reduces the number of instances that must be written to actually use @Generic1@
    for deriving instances of other classes.

    For more details, see the "Generics.Linear" documentation.

    This library is organized as follows:

    * "Generics.Linear" defines the core functionality for generics,
    including the multiplicity-polymorphic @Generic(1)@ classes and
    a replacement for the @:.:@ composition type.

    * "Generics.Linear.TH" implements Template Haskell functionality for
    deriving instances of @Generic(1)@.

    * "Generics.Linear.Unsafe.ViaGHCGenerics" offers @DerivingVia@ targets to
    derive @Generic@ and @Generic1@ instances from
    @"GHC.Generics".'\''GHC.Generics.Generic'\''@. Because these instances necessarily
    use unsafe coercions, their use will likely inhibit full optimization of
    code using them.

    Educational code: the educational modules exported by
    <https://hackage.haskell.org/package/generic-deriving generic-deriving>
    have been copied into the @tests\/Generic\/Deriving@ directory
    in this repository, with the very few modifications required to
    accommodate the differences between the @Generic1@ representations
    here and in @base@. All the same caveats apply as in the originals;
    see that package'\''s @README@.

category:             Generics
abi:                  08a97d0c23a8962a5a37bc383d703d07
exposed:              True
exposed-modules:
    Generics.Linear Generics.Linear.TH Generics.Linear.TH.Insertions
    Generics.Linear.Unsafe.ViaGHCGenerics

hidden-modules:
    Generics.Linear.Instances Generics.Linear.Class
    Generics.Linear.TH.Internal Generics.Linear.TH.MetaData
    Generics.Linear.Instances.Base Generics.Linear.Instances.Containers
    Generics.Linear.Instances.Linear_generics
    Generics.Linear.Instances.Template_haskell

import-dirs:          /usr/lib/ghc-9.2.8/site-local/linear-generics-0.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/linear-generics-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-linear-generics
hs-libraries:         HSlinear-generics-0.2.1-8D81N8Lqp4D1Kt3ea4t44S
depends:
    base-4.16.4.0 containers-0.6.5.1 ghc-prim-0.8.0
    template-haskell-2.18.0.0
    th-abstraction-0.4.5.0-FQrzhXbdvQX3Z0wTw3euNu

haddock-interfaces:
    /usr/share/doc/haskell-linear-generics/html/linear-generics.haddock

haddock-html:         /usr/share/doc/haskell-linear-generics/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

