#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.6.0.0
visibility:           public
id:                   lsp-1.6.0.0-CM6WDlt9oDB5Oz9CDPKUO7
key:                  lsp-1.6.0.0-CM6WDlt9oDB5Oz9CDPKUO7
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  cb870893f924300c1e9ad2cdb17a9bd0
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb:Language.LSP.Types.Lens,
    Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-1.6.0.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-1.6.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-1.6.0.0-CM6WDlt9oDB5Oz9CDPKUO7
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    bytestring-0.11.4.0 co-log-core-0.3.2.1-7JZBDXVX58r8HuUo9Uiiik
    containers-0.6.5.1 data-default-0.7.1.1-LSJh75QrCu1H2SWBLBb1YB
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb mtl-2.2.2
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH
    sorted-list-0.2.2.0-41XPxeYLLUnGQeEO6eeM9Z stm-2.5.0.2
    temporary-1.3-ATBZpgmb4kkJvnIbOIhyK2 text-1.2.5.0
    text-rope-0.2-AvsDTmFZz4PG9BGi4lmkBx transformers-0.5.6.2
    unliftio-core-0.2.1.0-2wlRerPMhUe3AYGiMsYOzn
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    uuid-1.3.15-sDtC8PfuMJ4kPM3zoEG7

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

