#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.1.0
visibility:           public
id:                   lsp-test-0.14.1.0-4C47zqDysdWLJSMv6vZUBX
key:                  lsp-test-0.14.1.0-4C47zqDysdWLJSMv6vZUBX
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  a59ba65e2e565a2c6a330f38a67855df
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.2.8/site-local/lsp-test-0.14.1.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/lsp-test-0.14.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.1.0-4C47zqDysdWLJSMv6vZUBX
depends:
    Diff-0.4.1-B9thiVs2y2uAiqx3tkly0v
    Glob-0.10.2-IV3EMKztTxU6CHYEAa9DJ0
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp base-4.16.4.0
    bytestring-0.11.4.0 co-log-core-0.3.2.1-7JZBDXVX58r8HuUo9Uiiik
    conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
    conduit-parse-0.2.1.1-K9B6c8lqBtJxs604gvieJ containers-0.6.5.1
    data-default-0.7.1.1-LSJh75QrCu1H2SWBLBb1YB directory-1.3.6.2
    exceptions-0.10.4 filepath-1.4.2.2
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    lsp-1.6.0.0-CM6WDlt9oDB5Oz9CDPKUO7
    lsp-types-1.6.0.0-A63ekFNN6F92bcaqnQodxb mtl-2.2.2
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5 process-1.6.16.0
    some-1.0.5-L5glA67mR8RJufLDsA2lRz text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

