#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mersenne-random-pure64
version:              0.2.2.0
visibility:           public
id:                   mersenne-random-pure64-0.2.2.0-FacljLGdUCjJv95fAhtU2o
key:                  mersenne-random-pure64-0.2.2.0-FacljLGdUCjJv95fAhtU2o
license:              BSD-3-Clause
copyright:            (c) 2008. Don Stewart <dons00@gmail.com>
maintainer:           Don Stewart <dons00@gmail.com>
author:               Don Stewart
homepage:             http://code.haskell.org/~dons/code/mersenne-random-pure64/
synopsis:
    Generate high quality pseudorandom numbers purely using a Mersenne Twister

description:
    The Mersenne twister is a pseudorandom number generator developed by
    Makoto Matsumoto and Takuji Nishimura that is based on a matrix linear
    recurrence over a finite binary field. It provides for fast generation
    of very high quality pseudorandom numbers. The source for the C code
    can be found here:

    <http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/emt64.html>

    This library provides a purely functional binding to the 64 bit
    classic mersenne twister, along with instances of RandomGen, so the
    generator can be used with System.Random. The generator should
    typically be a few times faster than the default StdGen (but a tad
    slower than the impure '\''mersenne-random'\'' library based on SIMD
    instructions and destructive state updates.

category:             Math, System
abi:                  3c70e038cb3a693f0cd415a84305c22f
exposed:              True
exposed-modules:
    System.Random.Mersenne.Pure64 System.Random.Mersenne.Pure64.Base
    System.Random.Mersenne.Pure64.Internal
    System.Random.Mersenne.Pure64.MTBlock

import-dirs:
    /usr/lib/ghc-9.2.8/site-local/mersenne-random-pure64-0.2.2.0

library-dirs:
    /usr/lib/ghc-9.2.8/site-local/mersenne-random-pure64-0.2.2.0

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mersenne-random-pure64
hs-libraries:         HSmersenne-random-pure64-0.2.2.0-FacljLGdUCjJv95fAhtU2o
include-dirs:
    /usr/lib/ghc-9.2.8/site-local/mersenne-random-pure64-0.2.2.0/include

depends:
    base-4.16.4.0 random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH time-1.11.1.1

haddock-interfaces:
    /usr/share/doc/haskell-mersenne-random-pure64/html/mersenne-random-pure64.haddock

haddock-html:         /usr/share/doc/haskell-mersenne-random-pure64/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

