#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 mwc-random
version:              0.15.0.2
visibility:           public
id:                   mwc-random-0.15.0.2-Eop8Bz4LJUj4hDWcjuxoAz
key:                  mwc-random-0.15.0.2-Eop8Bz4LJUj4hDWcjuxoAz
license:              BSD-3-Clause
copyright:            2009, 2010, 2011 Bryan O'\''Sullivan
maintainer:           Bryan O'\''Sullivan <bos@serpentine.com>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             https://github.com/bos/mwc-random
synopsis:             Fast, high quality pseudo random number generation
description:
    This package contains code for generating high quality random
    numbers that follow either a uniform or normal distribution.  The
    generated numbers are suitable for use in statistical applications.

    The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
    multiply-with-carry generator, which has a period of 2^8222 and
    fares well in tests of randomness.  It is also extremely fast,
    between 2 and 3 times faster than the Mersenne Twister.

    Compared to the mersenne-random package, this package has a more
    convenient API, is faster, and supports more statistical
    distributions.

category:             Math, Statistics
abi:                  9c74ebeb00cd85aef2872e2a12a490fa
exposed:              True
exposed-modules:
    System.Random.MWC System.Random.MWC.CondensedTable
    System.Random.MWC.Distributions System.Random.MWC.SeedSource

import-dirs:          /usr/lib/ghc-9.2.8/site-local/mwc-random-0.15.0.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/mwc-random-0.15.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-mwc-random
hs-libraries:         HSmwc-random-0.15.0.2-Eop8Bz4LJUj4hDWcjuxoAz
depends:
    base-4.16.4.0 math-functions-0.3.4.4-8CoTo8xbfvgGywcZ96VmZD
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH time-1.11.1.1
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-mwc-random/html/mwc-random.haddock
haddock-html:         /usr/share/doc/haskell-mwc-random/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

