#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgresql-binary
version:              0.12.5
visibility:           public
id:                   postgresql-binary-0.12.5-Buu9GXGOmx2CBno30jmt9y
key:                  postgresql-binary-0.12.5-Buu9GXGOmx2CBno30jmt9y
license:              MIT
copyright:            (c) 2014, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/postgresql-binary 
synopsis:             Encoders and decoders for the PostgreSQL'\''s binary format
description:
    An API for dealing with PostgreSQL'\''s binary data format.

    It can be used to implement performant bindings to Postgres.
    E.g., <http://hackage.haskell.org/package/hasql hasql>
    is based on this library.

    It supports all Postgres versions starting from 8.3
    and is tested against 8.3, 9.3 and 9.5
    with the @integer_datetimes@ setting off and on.

category:             PostgreSQL, Database, Codecs, Parsing
abi:                  febd505c192ebba4f9ea93cf73dad429
exposed:              True
exposed-modules:
    PostgreSQL.Binary.Data PostgreSQL.Binary.Decoding
    PostgreSQL.Binary.Encoding

hidden-modules:
    PostgreSQL.Binary.Encoding.Builders PostgreSQL.Binary.Prelude
    PostgreSQL.Binary.Integral PostgreSQL.Binary.Interval
    PostgreSQL.Binary.Numeric PostgreSQL.Binary.Time
    PostgreSQL.Binary.Inet PostgreSQL.Binary.BuilderPrim

import-dirs:          /usr/lib/ghc-9.2.8/site-local/postgresql-binary-0.12.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/postgresql-binary-0.12.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-postgresql-binary
hs-libraries:         HSpostgresql-binary-0.12.5-Buu9GXGOmx2CBno30jmt9y
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI base-4.16.4.0
    binary-parser-0.5.7.6-Kn1uIHnQAWtA1f1H3ZdheF bytestring-0.11.4.0
    bytestring-strict-builder-0.4.5.7-Jnl8r95VqkYJEv02EryGoS
    containers-0.6.5.1 network-ip-0.3.0.3-4YBLFfWpOGs5JfkHfcF0yW
    scientific-0.3.7.0-72r9rPpXaeUjwM4XNBSJR text-1.2.5.0 time-1.11.1.1
    transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    uuid-1.3.15-sDtC8PfuMJ4kPM3zoEG7
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:
    /usr/share/doc/haskell-postgresql-binary/html/postgresql-binary.haddock

haddock-html:         /usr/share/doc/haskell-postgresql-binary/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

