#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 random-fu
version:              0.3.0.1
visibility:           public
id:                   random-fu-0.3.0.1-90FaScOQrkRJwxuEm4xT4b
key:                  random-fu-0.3.0.1-90FaScOQrkRJwxuEm4xT4b
license:              LicenseRef-PublicDomain
maintainer:           Dominic Steinitz <dominic@steinitz.org>
author:               James Cook <mokus@deepbondi.net>
stability:            provisional
homepage:             https://github.com/mokus0/random-fu
synopsis:             Random number generation
description:
    Random number generation based on modeling random
    variables in two complementary ways: first, by the
    parameters of standard mathematical distributions and,
    second, by an abstract type ('\''RVar'\'') which can be
    composed and manipulated monadically and sampled in
    either monadic or \"pure\" styles.

    The primary purpose of this library is to support
    defining and sampling a wide variety of high quality
    random variables.  Quality is prioritized over speed,
    but performance is an important goal too.

    In my testing, I have found it capable of speed
    comparable to other Haskell libraries, but still
    a fair bit slower than straight C implementations of
    the same algorithms.

category:             Math
abi:                  e21be3dbaa4ff4b7388ede4b48cf78d2
exposed:              True
exposed-modules:
    Data.Random Data.Random.Distribution
    Data.Random.Distribution.Bernoulli Data.Random.Distribution.Beta
    Data.Random.Distribution.Binomial
    Data.Random.Distribution.Categorical
    Data.Random.Distribution.ChiSquare
    Data.Random.Distribution.Dirichlet
    Data.Random.Distribution.Exponential Data.Random.Distribution.Gamma
    Data.Random.Distribution.Multinomial
    Data.Random.Distribution.Normal Data.Random.Distribution.Pareto
    Data.Random.Distribution.Poisson Data.Random.Distribution.Rayleigh
    Data.Random.Distribution.Simplex
    Data.Random.Distribution.StretchedExponential
    Data.Random.Distribution.T Data.Random.Distribution.Triangular
    Data.Random.Distribution.Uniform Data.Random.Distribution.Weibull
    Data.Random.Distribution.Ziggurat Data.Random.Internal.Find
    Data.Random.Internal.Fixed Data.Random.Lift Data.Random.List
    Data.Random.RVar Data.Random.Sample Data.Random.Vector

import-dirs:          /usr/lib/ghc-9.2.8/site-local/random-fu-0.3.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/random-fu-0.3.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-random-fu
hs-libraries:         HSrandom-fu-0.3.0.1-90FaScOQrkRJwxuEm4xT4b
depends:
    base-4.16.4.0 erf-2.0.0.0-5wUg0hFZ5TmCeYzfUgzGpS
    math-functions-0.3.4.4-8CoTo8xbfvgGywcZ96VmZD
    monad-loops-0.4.3-1PoLx7GFY2f6JjKzBe0o6E mtl-2.2.2
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH
    random-shuffle-0.0.4-44wlIuqnXmw4oV5gYiS0Rq
    rvar-0.3.0.2-LgsJzC5IrHABzFSGkngXde
    syb-0.7.2.4-IT59ozboet0H3NdhoNJGts template-haskell-2.18.0.0
    transformers-0.5.6.2 vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-random-fu/html/random-fu.haddock
haddock-html:         /usr/share/doc/haskell-random-fu/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

