#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 SafeSemaphore
version:              0.10.1
visibility:           public
id:                   SafeSemaphore-0.10.1-1qs9ubJfNLEEBi10E0FWui
key:                  SafeSemaphore-0.10.1-1qs9ubJfNLEEBi10E0FWui
license:              BSD-3-Clause
maintainer:           Chris Kuklewicz <haskell@list.mightyreason.com>
author:               Chris Kuklewicz <haskell@list.mightyreason.com>
homepage:             https://github.com/ChrisKuklewicz/SafeSemaphore
synopsis:             Much safer replacement for QSemN, QSem, and SampleVar
description:
    This provides a much safer semaphore than the QSem, QSemN, SampleVar in base.
    Those base modules are not exception safe and can be broken by killThread.
    See <https://github.com/ChrisKuklewicz/SafeSemaphore> for more details.

category:             Concurrency
abi:                  456108b35b47f7f17ec94340ee45c5b6
exposed:              True
exposed-modules:
    Control.Concurrent.FairRWLock Control.Concurrent.MSampleVar
    Control.Concurrent.MSem Control.Concurrent.MSemN
    Control.Concurrent.MSemN2 Control.Concurrent.SSem
    Control.Concurrent.STM.SSem

hidden-modules:       Control.Concurrent.STM.SSemInternals
import-dirs:          /usr/lib/ghc-9.2.8/site-local/SafeSemaphore-0.10.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/SafeSemaphore-0.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-safesemaphore
hs-libraries:         HSSafeSemaphore-0.10.1-1qs9ubJfNLEEBi10E0FWui
depends:              base-4.16.4.0 containers-0.6.5.1 stm-2.5.0.2
haddock-interfaces:
    /usr/share/doc/haskell-safesemaphore/html/SafeSemaphore.haddock

haddock-html:         /usr/share/doc/haskell-safesemaphore/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

