#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 scotty
version:              0.21
visibility:           public
id:                   scotty-0.21-3fphUNNbzaR2EAyd7jPFLk
key:                  scotty-0.21-3fphUNNbzaR2EAyd7jPFLk
license:              BSD-3-Clause
copyright:            (c) 2012-Present, Andrew Farmer and the Scotty contributors
maintainer:           The Scotty maintainers
author:               Andrew Farmer <xichekolas@gmail.com>
stability:            experimental
homepage:             https://github.com/scotty-web/scotty
synopsis:
    Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp

description:
    A Haskell web framework inspired by Ruby'\''s Sinatra, using WAI and Warp.

    @
    &#123;-&#35; LANGUAGE OverloadedStrings &#35;-&#125;

    import Web.Scotty

    main = scotty 3000 $
    &#32;&#32;get &#34;/:word&#34; $ do
    &#32;&#32;&#32;&#32;beam <- pathParam &#34;word&#34;
    &#32;&#32;&#32;&#32;html $ mconcat [&#34;&#60;h1&#62;Scotty, &#34;, beam, &#34; me up!&#60;/h1&#62;&#34;]
    @


    Scotty is the cheap and cheerful way to write RESTful, declarative web applications.

    * A page is as simple as defining the verb, url pattern, and Text content.

    * It is template-language agnostic. Anything that returns a Text value will do.

    * Conforms to WAI Application interface.

    * Uses very fast Warp webserver by default.

    As for the name: Sinatra + Warp = Scotty.

    [WAI] <http://hackage.haskell.org/package/wai>

    [Warp] <http://hackage.haskell.org/package/warp>

category:             Web
abi:                  a38cf70612ae9b168b678df1f84b0429
exposed:              True
exposed-modules:
    Web.Scotty Web.Scotty.Cookie Web.Scotty.Internal.Types
    Web.Scotty.Trans Web.Scotty.Trans.Strict

hidden-modules:
    Web.Scotty.Action Web.Scotty.Body Web.Scotty.Route
    Web.Scotty.Trans.Lazy Web.Scotty.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/scotty-0.21
library-dirs:         /usr/lib/ghc-9.2.8/site-local/scotty-0.21
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-scotty
hs-libraries:         HSscotty-0.21-3fphUNNbzaR2EAyd7jPFLk
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI base-4.16.4.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp exceptions-0.10.4
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    monad-control-1.0.3.1-AX02qra1qxmHNghOyTYjz4 mtl-2.2.2
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    regex-compat-0.95.2.1-6r4iKSNuQHkEjgz1ilm8wy stm-2.5.0.2
    text-1.2.5.0 time-1.11.1.1 transformers-0.5.6.2
    transformers-base-0.4.6-IOayaC279jG1puxw49VnQP
    transformers-compat-0.7.2-9ApmiRwA3hS7UuQpOomcS
    unliftio-0.2.25.0-INoatlssrBVAcEPI6HA5Cp
    wai-3.2.4-F4LWzzhSgqd90OuFMQ1Kx1
    wai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
    warp-3.3.30-JHUoXLMS4FILpIjCS0pSyJ

haddock-interfaces:   /usr/share/doc/haskell-scotty/html/scotty.haddock
haddock-html:         /usr/share/doc/haskell-scotty/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

