#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 semialign
version:              1.2.0.1
visibility:           public
id:                   semialign-1.2.0.1-i2AX6g3cUSDjBEjE4wvRC
key:                  semialign-1.2.0.1-i2AX6g3cUSDjBEjE4wvRC
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               C. McCann, Oleg Grenrus
homepage:             https://github.com/haskellari/these
synopsis:
    Align and Zip type-classes from the common Semialign ancestor.

description:
    The major use of @These@ of this is provided by the @align@ member of
    @Semialign@ class, representing a generalized notion of "zipping with padding"
    that combines structures without truncating to the size of the smaller input.

    It turns out that @zip@ operation fits well the @Semialign@ class,
    forming lattice-like structure.

category:             Data, These
abi:                  08a54a3342f453c968f2cd41819c6028
exposed:              True
exposed-modules:
    Data.Align Data.Crosswalk Data.Semialign Data.Semialign.Indexed
    Data.Zip

hidden-modules:       Data.Semialign.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/semialign-1.2.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-semialign
hs-libraries:         HSsemialign-1.2.0.1-i2AX6g3cUSDjBEjE4wvRC
depends:
    base-4.16.4.0 containers-0.6.5.1
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
    indexed-traversable-instances-0.1.1.2-1Fjq2phzgHUHDJ57Bb8XWq
    semigroupoids-5.3.7-1YYAPqLiz5I2tSx9QdPdOI
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg
    these-1.1.1.1-937taxbfKa84JlSmdXavvz transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-semialign/html/semialign.haddock
haddock-html:         /usr/share/doc/haskell-semialign/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

