#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 servant-swagger
version:              1.2
visibility:           public
id:                   servant-swagger-1.2-GpH8Ku9ehti5ZMmHUAigy7
key:                  servant-swagger-1.2-GpH8Ku9ehti5ZMmHUAigy7
license:              BSD-3-Clause
copyright:            (c) 2015-2018, Servant contributors
maintainer:           haskell-servant-maintainers@googlegroups.com
author:               Servant Contributors
homepage:
    https://github.com/haskell-servant/servant/tree/master/servant-swagger#readme

synopsis:
    Generate a Swagger/OpenAPI/OAS 2.0 specification for your servant API.

description:
    Swagger is a project used to describe and document RESTful APIs. The core of the
    project is the [OpenAPI Specification (OAS)](https://swagger.io/docs/specification/about/).
    This library implements v2.0 of the spec. Unlike Servant it is language-agnostic and thus is
    quite popular among developers in different languages. It has also existed for a longer time
    and has more helpful tooling.

    This package provides means to generate a Swagger/OAS specification for a Servant API
    and also to partially test whether an API conforms with its specification.

    Generated Swagger specification then can be used for many things such as

    * displaying interactive documentation using [Swagger UI](http://swagger.io/swagger-ui/);

    * generating clients and servers in many languages using [Swagger Codegen](http://swagger.io/swagger-codegen/);

    * and [many others](http://swagger.io/open-source-integrations/).

category:             Web, Servant, Swagger
abi:                  20e6c929d76cad097ca017a4aafc1e3d
exposed:              True
exposed-modules:
    Servant.Swagger Servant.Swagger.Internal
    Servant.Swagger.Internal.Orphans Servant.Swagger.Internal.Test
    Servant.Swagger.Internal.TypeLevel
    Servant.Swagger.Internal.TypeLevel.API
    Servant.Swagger.Internal.TypeLevel.Every
    Servant.Swagger.Internal.TypeLevel.TMap Servant.Swagger.Test
    Servant.Swagger.TypeLevel

import-dirs:          /usr/lib/ghc-9.2.8/site-local/servant-swagger-1.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/servant-swagger-1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-servant-swagger
hs-libraries:         HSservant-swagger-1.2-GpH8Ku9ehti5ZMmHUAigy7
depends:
    QuickCheck-2.14.3-2FUI0ycZlrbG7BkVMiUKvc
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    aeson-pretty-0.8.10-EHbhnR4q86z8KHGoK5kE27 base-4.16.4.0
    base-compat-0.12.2-5hQPtIjgG5LKnb20qwjRWd bytestring-0.11.4.0
    hspec-2.10.9-2iQtDSEDAgdBujKiNNwOp1
    http-media-0.8.1.1-1UoBDThrCUL9FeZPpmgYTj
    insert-ordered-containers-0.2.5.3-5AWHSXkSaRtlqI83F0ze9
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    servant-0.20.1-BfYVs9aeRBaCSZsWFajbNO
    singleton-bool-0.1.7-2tDFkbjFLK6CMTjgJvZrRz
    swagger2-2.8.8-HpsJUfoGjg66GnxFm1OZbh text-1.2.5.0
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox

haddock-interfaces:
    /usr/share/doc/haskell-servant-swagger/html/servant-swagger.haddock

haddock-html:         /usr/share/doc/haskell-servant-swagger/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

