#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 snap-core
version:              1.0.5.1
visibility:           public
id:                   snap-core-1.0.5.1-6wAAa8z3x8nGFAoyOrcdsa
key:                  snap-core-1.0.5.1-6wAAa8z3x8nGFAoyOrcdsa
license:              BSD-3-Clause
maintainer:           snap@snapframework.com
author:               Snap Framework Authors (see CONTRIBUTORS)
homepage:             http://snapframework.com/
synopsis:             Snap: A Haskell Web Framework (core interfaces and types)
description:
    Snap is a simple and fast web development framework and server written in
    Haskell. For more information or to download the latest version, you can
    visit the Snap project website at <http://snapframework.com/>.

    This library contains the core definitions and types for the Snap framework,
    including:

    1. Primitive types and functions for HTTP (requests, responses, cookies,
    post/query parameters, etc)

    2. A monad for programming web handlers called \"Snap\", which allows:

    * Stateful access to the HTTP request and response objects

    * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
    to handle requests and chaining handlers together

    * Early termination of the computation if you know early what you want
    to return and want to prevent further monadic processing

    /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Core".

category:             Web, Snap, IO-Streams
abi:                  b196206e2875b58d04bd4b59037d7171
exposed:              True
exposed-modules:
    Snap.Core Snap.Internal.Core Snap.Internal.Debug
    Snap.Internal.Http.Types Snap.Internal.Parsing
    Snap.Internal.Util.FileServe Snap.Test Snap.Types.Headers
    Snap.Util.CORS Snap.Util.FileServe Snap.Util.FileUploads
    Snap.Util.GZip Snap.Util.Proxy

hidden-modules:
    Snap.Internal.Instances Snap.Internal.Routing
    Snap.Internal.Test.RequestBuilder Snap.Internal.Test.Assertions
    Snap.Internal.Util.FileUploads

import-dirs:          /usr/lib/ghc-9.2.8/site-local/snap-core-1.0.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/snap-core-1.0.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-snap-core
hs-libraries:         HSsnap-core-1.0.5.1-6wAAa8z3x8nGFAoyOrcdsa
depends:
    HUnit-1.6.2.0-8V4cpd2vyM7I9OG8MrEdHy
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    containers-0.6.5.1 directory-1.3.6.2 filepath-1.4.2.2
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    io-streams-1.5.2.2-JjUaMNqSGAIYlROXSOyCT
    lifted-base-0.2.3.12-E3byI5R2ZjdBBfIEgy1VPo
    monad-control-1.0.3.1-AX02qra1qxmHNghOyTYjz4 mtl-2.2.2
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    network-uri-2.6.4.2-BteEq2hoHgh9OCrkgJDHXL
    old-locale-1.0.0.7-DSFeUNZwxUU2YUIlh1bsq7
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH
    readable-0.3.1-ELy7rHtD1IYJJNZUAgGrUz
    regex-posix-0.96.0.1-Genc39RUTH74GYzEFB6fWq text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2
    transformers-base-0.4.6-IOayaC279jG1puxw49VnQP
    unix-compat-0.7.1-Ji3oWsDN9r7BYaictPFTjQ
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:   /usr/share/doc/haskell-snap-core/html/snap-core.haddock
haddock-html:         /usr/share/doc/haskell-snap-core/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

