#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 some
version:              1.0.5
visibility:           public
id:                   some-1.0.5-L5glA67mR8RJufLDsA2lRz
key:                  some-1.0.5-L5glA67mR8RJufLDsA2lRz
license:              BSD-3-Clause
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:
    James Cook <mokus@deepbondi.net>, Oleg Grenrus <oleg.grenrus@iki.fi>

homepage:             https://github.com/haskellari/some
synopsis:             Existential type: Some
description:
    This library defines an existential type '\''Some'\''.

    @
    data Some f where
    \    Some :: f a -> Some f
    @

    in few variants, and utilities to work with it.

    If you are unsure which variant to use, use the one in "Data.Some" module.

category:             Data, Dependent Types
abi:                  fd827ad988f4ee1af3c5929ccafb7db0
exposed:              True
exposed-modules:
    Data.EqP Data.GADT.Compare Data.GADT.DeepSeq Data.GADT.Show
    Data.OrdP Data.Some Data.Some.Church Data.Some.GADT
    Data.Some.Newtype

hidden-modules:       Data.GADT.Internal
import-dirs:          /usr/lib/ghc-9.2.8/site-local/some-1.0.5
library-dirs:         /usr/lib/ghc-9.2.8/site-local/some-1.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-some
hs-libraries:         HSsome-1.0.5-L5glA67mR8RJufLDsA2lRz
depends:              base-4.16.4.0 deepseq-1.4.6.1
haddock-interfaces:   /usr/share/doc/haskell-some/html/some.haddock
haddock-html:         /usr/share/doc/haskell-some/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

