#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 statistics
version:              0.16.2.1
visibility:           public
id:                   statistics-0.16.2.1-9ALTZk2OmdbKkBCYFpoFHl
key:                  statistics-0.16.2.1-9ALTZk2OmdbKkBCYFpoFHl
license:              BSD-2-Clause
copyright:            2009-2014 Bryan O'\''Sullivan
maintainer:           Alexey Khudaykov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>, Alexey Khudaykov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/haskell/statistics
synopsis:             A library of statistical types, data, and functions
description:
    This library provides a number of common functions and types useful
    in statistics.  We focus on high performance, numerical robustness,
    and use of good algorithms.  Where possible, we provide
    references to the statistical literature.

    The library'\''s facilities can be divided into four broad categories:

    * Working with widely used discrete and continuous probability
    distributions.  (There are dozens of exotic distributions in use;
    we focus on the most common.)

    * Computing with sample data: quantile estimation, kernel density
    estimation, histograms, bootstrap methods, significance testing,
    and regression and autocorrelation analysis.

    * Random variate generation under several different distributions.

    * Common statistical tests for significant differences between
    samples.

category:             Math, Statistics
abi:                  e1fb460085cfba73a801005d09427502
exposed:              True
exposed-modules:
    Statistics.Autocorrelation Statistics.ConfidenceInt
    Statistics.Correlation Statistics.Correlation.Kendall
    Statistics.Distribution Statistics.Distribution.Beta
    Statistics.Distribution.Binomial
    Statistics.Distribution.CauchyLorentz
    Statistics.Distribution.ChiSquared
    Statistics.Distribution.DiscreteUniform
    Statistics.Distribution.Exponential
    Statistics.Distribution.FDistribution Statistics.Distribution.Gamma
    Statistics.Distribution.Geometric
    Statistics.Distribution.Hypergeometric
    Statistics.Distribution.Laplace Statistics.Distribution.Lognormal
    Statistics.Distribution.NegativeBinomial
    Statistics.Distribution.Normal Statistics.Distribution.Poisson
    Statistics.Distribution.StudentT Statistics.Distribution.Transform
    Statistics.Distribution.Uniform Statistics.Distribution.Weibull
    Statistics.Function Statistics.Quantile Statistics.Regression
    Statistics.Resampling Statistics.Resampling.Bootstrap
    Statistics.Sample Statistics.Sample.Histogram
    Statistics.Sample.Internal Statistics.Sample.KernelDensity
    Statistics.Sample.KernelDensity.Simple Statistics.Sample.Normalize
    Statistics.Sample.Powers Statistics.Test.ChiSquared
    Statistics.Test.KolmogorovSmirnov Statistics.Test.KruskalWallis
    Statistics.Test.MannWhitneyU Statistics.Test.StudentT
    Statistics.Test.Types Statistics.Test.WilcoxonT
    Statistics.Transform Statistics.Types

hidden-modules:
    Statistics.Distribution.Poisson.Internal Statistics.Internal
    Statistics.Test.Internal Statistics.Types.Internal

import-dirs:          /usr/lib/ghc-9.2.8/site-local/statistics-0.16.2.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/statistics-0.16.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-statistics
hs-libraries:         HSstatistics-0.16.2.1-9ALTZk2OmdbKkBCYFpoFHl
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp base-4.16.4.0 binary-0.8.9.0
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp deepseq-1.4.6.1
    dense-linear-algebra-0.1.0.0-IZ7l6FJbSpOGrxCmYSctXV
    math-functions-0.3.4.4-8CoTo8xbfvgGywcZ96VmZD
    mwc-random-0.15.0.2-Eop8Bz4LJUj4hDWcjuxoAz
    parallel-3.2.2.0-KgDyPHm89eYAjQsIhXthC1
    primitive-0.7.4.0-IuAkHfsD4drDvErljoigXB
    random-1.2.1.2-LCKSS7rEcRbACR8x8dKjFH
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe
    vector-algorithms-0.9.0.2-5HJKHPYe5izsaUwKsWj43
    vector-binary-instances-0.2.5.2-3MMHy6eHBQbVnmqowGmJR
    vector-th-unbox-0.2.2-IIEmXSq9fmfICJl9iTlusJ

haddock-interfaces:   /usr/share/doc/haskell-statistics/html/statistics.haddock
haddock-html:         /usr/share/doc/haskell-statistics/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

