#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 tamarin-prover-utils
version:              1.8.0
visibility:           public
id:                   tamarin-prover-utils-1.8.0-BjCPuIRZvNa1DgjVQPXXNd
key:                  tamarin-prover-utils-1.8.0-BjCPuIRZvNa1DgjVQPXXNd
license:              LicenseRef-GPL
copyright:
    Benedikt Schmidt, Simon Meier, Cas Cremers, Jannik Dreier, Ralf Sasse, 2010-2023

maintainer:
    Cas Cremers <cremers@cispa.de>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

author:
    Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
    Simon Meier <simon.meier@inf.ethz.ch>,
    Jannik Dreier <research@jannikdreier.net>,
    Ralf Sasse <ralf.sasse@gmail.com>

homepage:             https://tamarin-prover.github.io/
synopsis:             Utility library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).

category:             Theorem Provers
abi:                  13311d96e41f6658f70fa7f18c052e2d
exposed:              True
exposed-modules:
    Control.Basics Control.Monad.Bind Control.Monad.Disj
    Control.Monad.Fresh Control.Monad.Trans.FastFresh
    Control.Monad.Trans.PreciseFresh Data.Color Data.DAG.Simple
    Debug.Trace.Ignore Extension.Data.ByteString Extension.Data.Label
    Extension.Data.Monoid Extension.Prelude Logic.Connectives
    System.Timing Text.Dot Text.PrettyPrint.Class
    Text.PrettyPrint.Highlight Text.PrettyPrint.Html Text.Unicode
    Utils.Misc

hidden-modules:
    Control.Monad.Fresh.Class Control.Monad.Trans.Disj
    Control.Monad.Disj.Class

import-dirs:          /usr/lib/ghc-9.2.8/site-local/tamarin-prover-utils-1.8.0
library-dirs:         /usr/lib/ghc-9.2.8/site-local/tamarin-prover-utils-1.8.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-tamarin-prover-utils
hs-libraries:         HStamarin-prover-utils-1.8.0-BjCPuIRZvNa1DgjVQPXXNd
depends:
    SHA-1.6.4.4-4vZ3YEU9upt6TqgW7hflaa base-4.16.4.0
    base64-bytestring-1.2.1.0-6ICZKEZtNauKUlSfxjYXGw binary-0.8.9.0
    blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK bytestring-0.11.4.0
    containers-0.6.5.1 deepseq-1.4.6.1 dlist-1.0-HCxoMn9TirQDgPCFxho7O
    exceptions-0.10.4 fclabels-2.0.5.1-JkQdhYNM3JJEdlX5hjsQCN mtl-2.2.2
    pretty-1.1.3.6 safe-0.3.21-CqIHKdkgiB2klcxc5dxay
    syb-0.7.2.4-IT59ozboet0H3NdhoNJGts time-1.11.1.1
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-tamarin-prover-utils/html/tamarin-prover-utils.haddock

haddock-html:         /usr/share/doc/haskell-tamarin-prover-utils/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

