#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-4Ewi0AD2UXK9S3vve7XbUg
key:                  trifecta-2.1.4-4Ewi0AD2UXK9S3vve7XbUg
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  697f4ca3753d1eff92258fd04ada33f7
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-4Ewi0AD2UXK9S3vve7XbUg
depends:
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK array-0.5.4.0
    base-4.16.4.0 blaze-builder-0.4.2.3-IKxRmKhVbHpBC9UJti3YbK
    blaze-html-0.9.1.2-A5KXBNyQdfKA6uCozbcuq2
    blaze-markup-0.8.3.0-FWMMHu9hei31HacT0lMzy9 bytestring-0.11.4.0
    charset-0.3.10-CJ90CsHJntd7Te8YoTPhil
    comonad-5.0.8-KyyLY8sZRYu3prGxjDqPYp containers-0.6.5.1
    deepseq-1.4.6.1 fingertree-0.1.5.0-632dat8ZnXXLYJBA1qq9rj
    ghc-prim-0.8.0 hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    indexed-traversable-0.1.3-cDxCqXMKkpJLEkpY6C7Mq
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO mtl-2.2.2
    parsers-0.12.11-9meE7NauUFTEfbHdqhNtA5
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5
    prettyprinter-ansi-terminal-1.1.3-Bk17MJ24jKO9mtEtdKdzwP
    profunctors-5.6.2-GpDaCOOY8ar8rCckMV8A0H
    reducers-3.12.4-2kJrCFqusgZH06NuFZvi58 transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

