#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 unicode-collation
version:              0.1.3.6
visibility:           public
id:                   unicode-collation-0.1.3.6-CQRRSp3DARyCZWgBXKOEpR
key:                  unicode-collation-0.1.3.6-CQRRSp3DARyCZWgBXKOEpR
license:              BSD-2-Clause
copyright:            2021 John MacFarlane
maintainer:           John MacFarlane <jgm@berkeley.edu>
author:               John MacFarlane
homepage:             https://github.com/jgm/unicode-collation
synopsis:             Haskell implementation of the Unicode Collation Algorithm
description:
    This library provides a pure Haskell implementation of
    the Unicode Collation Algorithm described at
    <http://www.unicode.org/reports/tr10/>.  It is not
    as fully-featured or as performant as @text-icu@, but
    it avoids a dependency on a large C library.
    Locale-specific tailorings are also provided.

category:             Text
abi:                  df1a9354a91a6e653620b4d13cf07dab
exposed:              True
exposed-modules:      Text.Collate Text.Collate.Lang Text.Collate.Normalize
hidden-modules:
    Text.Collate.Trie Text.Collate.Collation Text.Collate.Collator
    Text.Collate.CanonicalCombiningClass Text.Collate.TH
    Text.Collate.Tailorings Text.Collate.UnicodeData

import-dirs:          /usr/lib/ghc-9.2.8/site-local/unicode-collation-0.1.3.6
library-dirs:         /usr/lib/ghc-9.2.8/site-local/unicode-collation-0.1.3.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-unicode-collation
hs-libraries:         HSunicode-collation-0.1.3.6-CQRRSp3DARyCZWgBXKOEpR
depends:
    base-4.16.4.0 binary-0.8.9.0 bytestring-0.11.4.0 containers-0.6.5.1
    parsec-3.1.15.0 template-haskell-2.18.0.0 text-1.2.5.0
    th-lift-instances-0.1.20-7md2lkWNOf8FA0lQCdfq6w

haddock-interfaces:
    /usr/share/doc/haskell-unicode-collation/html/unicode-collation.haddock

haddock-html:         /usr/share/doc/haskell-unicode-collation/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

