#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 universe-base
version:              1.1.4
visibility:           public
id:                   universe-base-1.1.4-DL2ztXAQ6Wd3LlRSDaJoHX
key:                  universe-base-1.1.4-DL2ztXAQ6Wd3LlRSDaJoHX
license:              BSD-3-Clause
copyright:            2014 Daniel Wagner
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:             A class for finite and recursively enumerable types.
description:
    A class for finite and recursively enumerable types and some helper functions for enumerating them.

    @
    class Universe a where universe :: [a]
    class Universe a => Finite a where universeF :: [a]; universeF = universe
    @

    This is slim package definiting only the type-classes and instances
    for types in GHC boot libraries.
    For more instances check @universe-instances-*@ packages.

category:             Data
abi:                  b41585a21503b73c0f3b7f94cc0eb60e
exposed:              True
exposed-modules:
    Data.Universe.Class Data.Universe.Generic Data.Universe.Helpers

import-dirs:          /usr/lib/ghc-9.2.8/site-local/universe-base-1.1.4
library-dirs:         /usr/lib/ghc-9.2.8/site-local/universe-base-1.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-universe-base
hs-libraries:         HSuniverse-base-1.1.4-DL2ztXAQ6Wd3LlRSDaJoHX
depends:
    base-4.16.4.0 containers-0.6.5.1
    tagged-0.8.8-404YCiJ2agdDxJGZ4AybXg transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-universe-base/html/universe-base.haddock

haddock-html:         /usr/share/doc/haskell-universe-base/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

