#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vector-binary-instances
version:              0.2.5.2
visibility:           public
id:                   vector-binary-instances-0.2.5.2-3MMHy6eHBQbVnmqowGmJR
key:                  vector-binary-instances-0.2.5.2-3MMHy6eHBQbVnmqowGmJR
license:              BSD-3-Clause
maintainer:
    dons00@gmail.com, bos@serpentine.com, Ben Gamari <ben@smart-cactus.org>

author:               Don Stewart
stability:            Experimental
homepage:             https://github.com/bos/vector-binary-instances
synopsis:             Instances of Data.Binary for vector
description:
    Instances for Binary for the types defined in the vector package,
    making it easy to serialize vectors to and from disk. We use the
    generic interface to vectors, so all vector types are supported.
    Specific instances are provided for unboxed, boxed and storable
    vectors.
    .
    To serialize a vector:
    .
    > *Data.Vector.Binary> let v = Data.Vector.fromList [1..10]
    > *Data.Vector.Binary> v
    > fromList [1,2,3,4,5,6,7,8,9,10] :: Data.Vector.Vector
    > *Data.Vector.Binary> encode v
    > Chunk "\NUL\NUL\NUL\NUL\NUL...\NUL\NUL\NUL\t\NUL\NUL\NUL\NUL\n" Empty
    .
    Which you can in turn compress before writing to disk:
    .
    > compress . encode $ v
    > Chunk "\US\139\b\NUL\NUL\N...\229\240,\254:\NUL\NUL\NUL" Empty
    .
    Try the cereal-vector package if you are looking for Data.Serialize
    instances.

category:             Data
abi:                  fbc4acac821001bb5b63f76643280d53
exposed:              True
exposed-modules:      Data.Vector.Binary
import-dirs:
    /usr/lib/ghc-9.2.8/site-local/vector-binary-instances-0.2.5.2

library-dirs:
    /usr/lib/ghc-9.2.8/site-local/vector-binary-instances-0.2.5.2

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-vector-binary-instances
hs-libraries:         HSvector-binary-instances-0.2.5.2-3MMHy6eHBQbVnmqowGmJR
depends:
    base-4.16.4.0 binary-0.8.9.0 vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe

haddock-interfaces:
    /usr/share/doc/haskell-vector-binary-instances/html/vector-binary-instances.haddock

haddock-html:         /usr/share/doc/haskell-vector-binary-instances/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

