#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 versions
version:              6.0.2
visibility:           public
id:                   versions-6.0.2-9T0g85LXgQU8oG2KUhniqU
key:                  versions-6.0.2-9T0g85LXgQU8oG2KUhniqU
license:              BSD-3-Clause
maintainer:           colin@fosskers.ca
author:               Colin Woodbury
homepage:             https://github.com/fosskers/versions
synopsis:             Types and parsers for software version numbers.
description:
    A library for parsing and comparing software version numbers. We like to give
    version numbers to our software in a myriad of ways. Some ways follow strict
    guidelines for incrementing and comparison. Some follow conventional wisdom
    and are generally self-consistent. Some are just plain asinine. This library
    provides a means of parsing and comparing /any/ style of versioning, be it a
    nice Semantic Version like this:

    > 1.2.3-r1+git123

    ...or a monstrosity like this:

    > 2:10.2+0.0093r3+1-1

    Please switch to <http://semver.org Semantic Versioning> if you aren'\''t
    currently using it. It provides consistency in version incrementing and has
    the best constraints on comparisons.

    This library implements version @2.0.0@ of the SemVer spec.

category:             Data
abi:                  1ca491a6cadcecf27fc170c9b8091e54
exposed:              True
exposed-modules:      Data.Versions
import-dirs:          /usr/lib/ghc-9.2.8/site-local/versions-6.0.2
library-dirs:         /usr/lib/ghc-9.2.8/site-local/versions-6.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-versions
hs-libraries:         HSversions-6.0.2-9T0g85LXgQU8oG2KUhniqU
depends:
    base-4.16.4.0 deepseq-1.4.6.1
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE
    parser-combinators-1.3.0-G0J7GFw9FY9Cgw8HeD2oK5
    template-haskell-2.18.0.0 text-1.2.5.0

haddock-interfaces:   /usr/share/doc/haskell-versions/html/versions.haddock
haddock-html:         /usr/share/doc/haskell-versions/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

