#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wai-extra
version:              3.1.15
visibility:           public
id:                   wai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
key:                  wai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
stability:            Stable
homepage:             http://github.com/yesodweb/wai
synopsis:             Provides some basic WAI handlers and middleware.
description:
    Provides basic WAI handler and middleware functionality:

    * WAI Testing Framework

    Hspec testing facilities and helpers for WAI.

    * Event Source/Event Stream

    Send server events to the client. Compatible with the JavaScript
    EventSource API.

    * Accept Override

    Override the Accept header in a request. Special handling for the
    _accept query parameter (which is used throughout WAI override the
    Accept header).

    * Add Headers

    WAI Middleware for adding arbitrary headers to an HTTP request.

    * Clean Path

    Clean a request path to a canonical form.

    * Combine Headers

    Combine duplicate headers into one.

    * GZip Compression

    Negotiate HTTP payload gzip compression.

    * Health check endpoint

    Add an empty health check endpoint.

    * HTTP Basic Authentication

    WAI Basic Authentication Middleware which uses Authorization header.

    * JSONP

    \"JSON with Padding\" middleware. Automatic wrapping of JSON
    responses to convert into JSONP.

    * Method Override / Post

    Allows overriding of the HTTP request method via the _method query string
    parameter.

    * Request Logging

    Request logging middleware for development and production environments

    * Request Rewrite

    Rewrite request path info based on a custom conversion rules.

    * Select

    Dynamically choose between Middlewares.

    * Stream Files

    Convert ResponseFile type responses into ResponseStream type.

    * Virtual Host

    Redirect incoming requests to a new host based on custom rules.


    API docs and the README are available at <http://www.stackage.org/package/wai-extra>.

category:             Web
abi:                  15993972ead955a1a1f53c1f4f03fa6c
exposed:              True
exposed-modules:
    Network.Wai.EventSource Network.Wai.EventSource.EventStream
    Network.Wai.Handler.CGI Network.Wai.Handler.SCGI Network.Wai.Header
    Network.Wai.Middleware.AcceptOverride
    Network.Wai.Middleware.AddHeaders Network.Wai.Middleware.Approot
    Network.Wai.Middleware.Autohead Network.Wai.Middleware.CleanPath
    Network.Wai.Middleware.CombineHeaders
    Network.Wai.Middleware.ForceDomain Network.Wai.Middleware.ForceSSL
    Network.Wai.Middleware.Gzip
    Network.Wai.Middleware.HealthCheckEndpoint
    Network.Wai.Middleware.HttpAuth Network.Wai.Middleware.Jsonp
    Network.Wai.Middleware.Local Network.Wai.Middleware.MethodOverride
    Network.Wai.Middleware.MethodOverridePost
    Network.Wai.Middleware.RealIp Network.Wai.Middleware.RequestLogger
    Network.Wai.Middleware.RequestLogger.JSON
    Network.Wai.Middleware.RequestSizeLimit
    Network.Wai.Middleware.RequestSizeLimit.Internal
    Network.Wai.Middleware.Rewrite Network.Wai.Middleware.Routed
    Network.Wai.Middleware.Select Network.Wai.Middleware.StreamFile
    Network.Wai.Middleware.StripHeaders Network.Wai.Middleware.Timeout
    Network.Wai.Middleware.ValidateHeaders Network.Wai.Middleware.Vhost
    Network.Wai.Parse Network.Wai.Request Network.Wai.Test
    Network.Wai.Test.Internal Network.Wai.UrlMap

hidden-modules:
    Network.Wai.Middleware.RequestLogger.Internal Network.Wai.Util

import-dirs:          /usr/lib/ghc-9.2.8/site-local/wai-extra-3.1.15
library-dirs:         /usr/lib/ghc-9.2.8/site-local/wai-extra-3.1.15
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wai-extra
hs-libraries:         HSwai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
depends:
    HUnit-1.6.2.0-8V4cpd2vyM7I9OG8MrEdHy
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK base-4.16.4.0
    base64-bytestring-1.2.1.0-6ICZKEZtNauKUlSfxjYXGw
    bytestring-0.11.4.0 call-stack-0.4.0-7Kj6UtaYY94JDoMxAZHX8y
    case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER containers-0.6.5.1
    cookie-0.4.6-ATAyIjNvKdDFVIoN0dB8l5
    data-default-class-0.1.2.0-Kt3ErptCt5hHHi8l61h1Gp directory-1.3.6.2
    fast-logger-3.1.2-HnAZqXh2ibQDdpLrIQb96a
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    iproute-1.7.12-IGvFWtPSYRS2JtTH2WH1Gh
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    resourcet-1.2.6-AkuAfAqfUrLC3kiGqtKSRc
    streaming-commons-0.2.2.6-BQfvqMZbFmf4h46rjHDijz text-1.2.5.0
    time-1.11.1.1 transformers-0.5.6.2 unix-2.7.2.2
    vault-0.3.1.5-A4AAN4O0TH9F8wPwf0MzPd
    wai-3.2.4-F4LWzzhSgqd90OuFMQ1Kx1
    wai-logger-2.4.0-FJHzVKHXUWa3TNjjgcjABv
    warp-3.3.30-JHUoXLMS4FILpIjCS0pSyJ
    word8-0.1.3-Bbsc0ZijkBHAg5mnae6Bis

haddock-interfaces:   /usr/share/doc/haskell-wai-extra/html/wai-extra.haddock
haddock-html:         /usr/share/doc/haskell-wai-extra/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

