#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 what4
version:              1.5.1
visibility:           public
id:                   what4-1.5.1-crYnjRwITJClCLnY7aYZf
key:                  what4-1.5.1-crYnjRwITJClCLnY7aYZf
license:              BSD-3-Clause
copyright:            (c) Galois, Inc 2014-2023
maintainer:           rscott@galois.com, kquick@galois.com
author:               Galois Inc.
homepage:             https://github.com/GaloisInc/what4
synopsis:             Solver-agnostic symbolic values support for issuing queries
description:
    What4 is a generic library for representing values as symbolic formulae which may
    contain references to symbolic values, representing unknown variables.
    It provides support for communicating with a variety of SAT and SMT solvers,
    including Z3, CVC4, CVC5, Yices, Boolector, STP, and dReal.
    The data representation types make heavy use of GADT-style type indices
    to ensure type-correct manipulation of symbolic values.

category:             Formal Methods, Theorem Provers, Symbolic Computation, SMT
abi:                  047f4c98b0df4e8b203a2a4f242fde9d
exposed:              True
exposed-modules:
    Test.Verification What4.BaseTypes What4.Concrete What4.Config
    What4.Expr What4.Expr.Allocator What4.Expr.App What4.Expr.AppTheory
    What4.Expr.ArrayUpdateMap What4.Expr.BoolMap What4.Expr.Builder
    What4.Expr.GroundEval What4.Expr.MATLAB What4.Expr.Simplify
    What4.Expr.StringSeq What4.Expr.UnaryBV
    What4.Expr.VarIdentification What4.Expr.WeightedSum What4.FloatMode
    What4.FunctionName What4.IndexLit What4.Interface
    What4.InterpretedFloatingPoint What4.LabeledPred What4.Panic
    What4.Partial What4.ProblemFeatures What4.ProgramLoc
    What4.Protocol.Online What4.Protocol.PolyRoot
    What4.Protocol.ReadDecimal What4.Protocol.SExp
    What4.Protocol.SMTLib2 What4.Protocol.SMTLib2.Parse
    What4.Protocol.SMTLib2.Response What4.Protocol.SMTLib2.Syntax
    What4.Protocol.SMTWriter What4.Protocol.VerilogWriter
    What4.Protocol.VerilogWriter.ABCVerilog
    What4.Protocol.VerilogWriter.AST
    What4.Protocol.VerilogWriter.Backend What4.SFloat What4.SWord
    What4.SatResult What4.SemiRing What4.Serialize.FastSExpr
    What4.Serialize.Log What4.Serialize.Normalize
    What4.Serialize.Parser What4.Serialize.Printer
    What4.Serialize.SETokens What4.Solver What4.Solver.Adapter
    What4.Solver.Boolector What4.Solver.CVC4 What4.Solver.CVC5
    What4.Solver.DReal What4.Solver.ExternalABC What4.Solver.STP
    What4.Solver.Yices What4.Solver.Z3 What4.SpecialFunctions
    What4.Symbol What4.Utils.AbstractDomains What4.Utils.AnnotatedMap
    What4.Utils.Arithmetic What4.Utils.BVDomain
    What4.Utils.BVDomain.Arith What4.Utils.BVDomain.Bitwise
    What4.Utils.BVDomain.XOR What4.Utils.Complex What4.Utils.Endian
    What4.Utils.Environment What4.Utils.FloatHelpers
    What4.Utils.HandleReader What4.Utils.IncrHash What4.Utils.LeqMap
    What4.Utils.MonadST What4.Utils.OnlyIntRepr What4.Utils.Process
    What4.Utils.ResolveBounds.BV What4.Utils.Serialize
    What4.Utils.Streams What4.Utils.StringLiteral What4.Utils.Versions
    What4.Utils.Word16String What4.WordMap

import-dirs:          /usr/lib/ghc-9.2.8/site-local/what4-1.5.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/what4-1.5.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-what4
hs-libraries:         HSwhat4-1.5.1-crYnjRwITJClCLnY7aYZf
depends:
    BoundedChan-1.0.3.0-GASw0jI0hsI8wIs0B8SAkA
    async-2.2.5-L1pFc6v09ikFDHHjgXlurp
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK base-4.16.4.0
    bifunctors-5.6-C3krR03Vy34Eh0jnv6kpRk
    bimap-0.5.0-Ezm3Pul1aocGiOTrQDC32r
    bv-sized-1.0.5-KeKfYWjVH78KWCcuJUGRZj bytestring-0.11.4.0
    concurrent-extra-0.7.0.12-Lbk9ZiXCq8mJWowVxrKPyC
    config-value-0.8.3-8yCRuGm4wH18pEPQuVa8HA containers-0.6.5.1
    deepseq-1.4.6.1 deriving-compat-0.6.6-3UM0cqKiKko5esVi806sKg
    directory-1.3.6.2 exceptions-0.10.4 filepath-1.4.2.2
    fingertree-0.1.5.0-632dat8ZnXXLYJBA1qq9rj ghc-prim-0.8.0
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    hashtables-1.3.1-Hmnbuv6HqNA8NY0t6CS25T
    io-streams-1.5.2.2-JjUaMNqSGAIYlROXSOyCT
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    libBF-0.6.5.1-1Nsw1daJ3FqBfEWC6R4gXC
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE mtl-2.2.2
    ordered-containers-0.2.3-Ee6QR9weM8P1AVLTbz9WQP
    panic-0.4.0.1-HPbW5wuhX2x4TYrkc6yjYz
    parameterized-utils-2.1.8.0-JqtCu6qgKdD29jAdpn1Xk6 parsec-3.1.15.0
    prettyprinter-1.7.1-1GpgcfSKvbVDLlexa0B7T5 process-1.6.16.0
    s-cargot-0.1.5.0-BdX2iCPOUK39xcU5oml5oR
    scientific-0.3.7.0-72r9rPpXaeUjwM4XNBSJR stm-2.5.0.2
    template-haskell-2.18.0.0 temporary-1.3-ATBZpgmb4kkJvnIbOIhyK2
    text-1.2.5.0 th-lift-0.8.4-7yLYwH7OaPD4aJs3FpHkYY
    th-lift-instances-0.1.20-7md2lkWNOf8FA0lQCdfq6w time-1.11.1.1
    transformers-0.5.6.2 unliftio-0.2.25.0-INoatlssrBVAcEPI6HA5Cp
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    vector-0.13.1.0-FuSYSqJEiCU51oStZmHlCe
    versions-6.0.2-9T0g85LXgQU8oG2KUhniqU
    zenc-0.1.2-3348YvzLcqx9Y22yDDHU8g

haddock-interfaces:   /usr/share/doc/haskell-what4/html/what4.haddock
haddock-html:         /usr/share/doc/haskell-what4/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

