#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 wreq
version:              0.5.4.3
visibility:           public
id:                   wreq-0.5.4.3-LRZ3mvx1rIK5oJYUJUHJlw
key:                  wreq-0.5.4.3-LRZ3mvx1rIK5oJYUJUHJlw
license:              BSD-3-Clause
copyright:            2014 Bryan O'\''Sullivan
maintainer:           bos@serpentine.com
author:               Bryan O'\''Sullivan <bos@serpentine.com>
homepage:             http://www.serpentine.com/wreq
synopsis:             An easy-to-use HTTP client library.
description:
    .
    A web client library that is designed for ease of use.
    .
    Tutorial: <http://www.serpentine.com/wreq/tutorial.html>
    .
    Features include:
    .
    * Simple but powerful `lens`-based API
    .
    * A solid test suite, and built on reliable libraries like
      http-client and lens
    .
    * Session handling includes connection keep-alive and pooling, and
      cookie persistence
    .
    * Automatic response body decompression
    .
    * Powerful multipart form and file upload handling
    .
    * Support for JSON requests and responses, including navigation of
      schema-less responses
    .
    * Basic and OAuth2 bearer authentication
    .
    * Early TLS support via the tls package

category:             Web
abi:                  d0f5c6c89841f5e45fe2cdaea55a2a07
exposed:              True
exposed-modules:
    Network.Wreq Network.Wreq.Cache Network.Wreq.Cache.Store
    Network.Wreq.Lens Network.Wreq.Session Network.Wreq.Types

hidden-modules:
    Network.Wreq.Internal Network.Wreq.Internal.AWS
    Network.Wreq.Internal.Lens Network.Wreq.Internal.Link
    Network.Wreq.Internal.OAuth1 Network.Wreq.Internal.Types
    Network.Wreq.Lens.Machinery Network.Wreq.Lens.TH Paths_wreq

import-dirs:          /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
library-dirs:         /usr/lib/ghc-9.2.8/site-local/wreq-0.5.4.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-wreq
hs-libraries:         HSwreq-0.5.4.3-LRZ3mvx1rIK5oJYUJUHJlw
depends:
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    attoparsec-0.14.4-Bi4fbguKdku98LXMy0bDoK
    authenticate-oauth-1.7-Hgd5l3hkcA1AlJwecUfMWR base-4.16.4.0
    base16-bytestring-1.0.2.0-2zrcaj2dASWLOg7ed8DTQL
    bytestring-0.11.4.0 case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    containers-0.6.5.1 crypton-0.34-8wHA6W5DE4sCu89hfEsb06
    exceptions-0.10.4 ghc-prim-0.8.0
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt
    http-client-0.7.15-1GC6b5Bmyn71sLeqrm25Gs
    http-client-tls-0.3.6.3-Cu35gZGVC8nBMMXS4AX6Fr
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    lens-5.2.3-9w28xeY3DMb2UpdPTesfcO
    lens-aeson-1.2.3-DQQ97BPOrPWFoHhQW4h9lj
    memory-0.18.0-Hvum6HaH78UJG59LYyNLK1
    mime-types-0.1.2.0-4X5b6Sz1aAM6TugVqfWYtQ
    psqueues-0.2.8.0-2OQKJAbUNrl4fTXmy1BF48 template-haskell-2.18.0.0
    text-1.2.5.0 time-1.11.1.1
    time-locale-compat-0.1.1.5-LoE3V3We7KBAnFwKjT98C2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox

haddock-interfaces:   /usr/share/doc/haskell-wreq/html/wreq.haddock
haddock-html:         /usr/share/doc/haskell-wreq/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

