#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger
version:              1.32.1
visibility:           public
id:                   hledger-1.32.1-Bs7tzClkaEiGIQeUp30MVW
key:                  hledger-1.32.1-Bs7tzClkaEiGIQeUp30MVW
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Command-line interface for the hledger accounting system
description:
    The command-line interface for the hledger accounting system.
    Its basic function is to read a plain text file describing
    financial transactions and produce useful reports.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance, Console
abi:                  c3bbbfbf05e16cfde5a7b5d3223b2e69
exposed:              True
exposed-modules:
    Hledger.Cli Hledger.Cli.Anon Hledger.Cli.CliOptions
    Hledger.Cli.Commands Hledger.Cli.Commands.Accounts
    Hledger.Cli.Commands.Activity Hledger.Cli.Commands.Add
    Hledger.Cli.Commands.Aregister Hledger.Cli.Commands.Balance
    Hledger.Cli.Commands.Balancesheet
    Hledger.Cli.Commands.Balancesheetequity
    Hledger.Cli.Commands.Cashflow Hledger.Cli.Commands.Check
    Hledger.Cli.Commands.Close Hledger.Cli.Commands.Codes
    Hledger.Cli.Commands.Commodities Hledger.Cli.Commands.Demo
    Hledger.Cli.Commands.Descriptions Hledger.Cli.Commands.Diff
    Hledger.Cli.Commands.Files Hledger.Cli.Commands.Help
    Hledger.Cli.Commands.Import Hledger.Cli.Commands.Incomestatement
    Hledger.Cli.Commands.Notes Hledger.Cli.Commands.Payees
    Hledger.Cli.Commands.Prices Hledger.Cli.Commands.Print
    Hledger.Cli.Commands.Register Hledger.Cli.Commands.Rewrite
    Hledger.Cli.Commands.Roi Hledger.Cli.Commands.Stats
    Hledger.Cli.Commands.Tags Hledger.Cli.CompoundBalanceCommand
    Hledger.Cli.DocFiles Hledger.Cli.Script Hledger.Cli.Utils
    Hledger.Cli.Version

hidden-modules:       Paths_hledger
import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger
hs-libraries:         HShledger-1.32.1-Bs7tzClkaEiGIQeUp30MVW
depends:
    Decimal-0.5.2-45gqLg1jNnsKjDC17gVM8a
    Diff-0.4.1-B9thiVs2y2uAiqx3tkly0v
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI
    ansi-terminal-0.11.4-EPVjDSBhsFM2RMZf92XUfK base-4.16.4.0
    bytestring-0.11.4.0 cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    containers-0.6.5.1 data-default-0.7.1.1-LSJh75QrCu1H2SWBLBb1YB
    directory-1.3.6.2 extra-1.7.15-A8zqWgaXJf2DqWdsYYbB9w
    filepath-1.4.2.2 githash-0.1.6.3-Hf61yXqxDs52GfOSixgdc8
    hashable-1.4.3.0-4gqtyFKn8Wu9OwsZtyYGdt haskeline-0.8.2
    hledger-lib-1.32.1-3Fdcz3OVHmX2MyZQsY6iRu
    lucid-2.11.20230408-1PzgHHzFiZ74capWDFNt4i
    math-functions-0.3.4.4-8CoTo8xbfvgGywcZ96VmZD
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE
    microlens-0.4.13.1-HPplyG5VOciEIF62YegSgA mtl-2.2.2
    process-1.6.16.0 regex-tdfa-1.3.2.2-Js34ukrBSX51v3nGkmx3s
    safe-0.3.21-CqIHKdkgiB2klcxc5dxay
    shakespeare-2.1.0.1-FVJV6NkyMoFKJ8nMfWeOi
    split-0.2.5-FikGR5xLeivE3fJUC4tXgQ
    tabular-0.2.2.8-95p3h1QIWwyCocci2BuF7w
    tasty-1.4.3-B04wakHanaTFmtNBHSmYAO
    temporary-1.3-ATBZpgmb4kkJvnIbOIhyK2 terminfo-0.4.1.5 text-1.2.5.0
    text-ansi-0.2.1.1-EZ03XoLJHB78JLu9zQDcJq time-1.11.1.1
    timeit-2.0-FPerWVMxZElJkpHtTsXEJ4 transformers-0.5.6.2
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    utility-ht-0.0.17.2-65OgehE96jxJMx8UmXKcKX
    wizards-1.0.3-614DR2XTBGc2LfYMK8q7fT

haddock-interfaces:   /usr/share/doc/hledger/html/hledger.haddock
haddock-html:         /usr/share/doc/hledger/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

