#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-BiObaJOFAYBZJtcaVWDmi
key:                  hledger-web-1.32.1-BiObaJOFAYBZJtcaVWDmi
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  0fa36627e120cd9e6dd676ba710bcc13
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.2.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-BiObaJOFAYBZJtcaVWDmi
depends:
    Decimal-0.5.2-45gqLg1jNnsKjDC17gVM8a
    aeson-2.1.2.1-3hy4hA3togDsVnwRqQAZI base-4.16.4.0
    base64-0.4.2.4-GO6iFdz3Rxw5QE8txq4rfa
    blaze-html-0.9.1.2-A5KXBNyQdfKA6uCozbcuq2
    blaze-markup-0.8.3.0-FWMMHu9hei31HacT0lMzy9 bytestring-0.11.4.0
    case-insensitive-1.2.1.0-GWeOjNQL6o11YPoz7mZGER
    clientsession-0.9.2.0-9us9KRDMxqqCzNwHmIlSv1
    cmdargs-0.10.22-JQ4ivQZzeRmKKTWVSPDfjg
    conduit-1.3.5-ALk6mfAxZFYZaKKv4bOWs
    conduit-extra-1.3.6-AphCoy0M4zlHtSPxz4pMHB containers-0.6.5.1
    data-default-0.7.1.1-LSJh75QrCu1H2SWBLBb1YB directory-1.3.6.2
    extra-1.7.15-A8zqWgaXJf2DqWdsYYbB9w filepath-1.4.2.2
    hjsmin-0.2.0.4-3MvJ1981x2SA3OrEExurJJ
    hledger-1.32.1-Bs7tzClkaEiGIQeUp30MVW
    hledger-lib-1.32.1-3Fdcz3OVHmX2MyZQsY6iRu
    hspec-2.10.9-2iQtDSEDAgdBujKiNNwOp1
    http-client-0.7.15-1GC6b5Bmyn71sLeqrm25Gs
    http-conduit-2.3.8.3-OGtiqVG63f9FEh9nh6oFl
    http-types-0.12.4-BQQx2t2WRPFKonJRzK2pM8
    megaparsec-9.5.0-7z3AThgMzs3rnIZVIvVtE mtl-2.2.2
    network-3.1.4.0-HWJHph1qrvp6tEtZHv7We0
    safe-0.3.21-CqIHKdkgiB2klcxc5dxay
    shakespeare-2.1.0.1-FVJV6NkyMoFKJ8nMfWeOi template-haskell-2.18.0.0
    text-1.2.5.0 time-1.11.1.1 transformers-0.5.6.2
    unix-compat-0.7.1-Ji3oWsDN9r7BYaictPFTjQ
    unordered-containers-0.2.20-3nVNqHdmWG59aZRDnxmFox
    utf8-string-1.0.2-9i4m1tpDbmh81tMCrQ25jI
    wai-3.2.4-F4LWzzhSgqd90OuFMQ1Kx1
    wai-cors-0.2.7-Hi1uxxHmRYpB24c0A2kby0
    wai-extra-3.1.15-3qbvQaSr7k23W6UoKe8gsz
    wai-handler-launch-3.0.3.1-18NGHwEIS0LIBp5c2Xlreg
    warp-3.3.30-JHUoXLMS4FILpIjCS0pSyJ
    yaml-0.11.11.2-HSWDpHOg3NMHkbNMquUv2x
    yesod-1.6.2.1-G9C94MOtLArKkML6SLmB9B
    yesod-core-1.6.26.0-7BgwU5RbLmC4szPfzLJRzA
    yesod-form-1.7.6-GnowOq1qiuzCI18mMEhNV5
    yesod-static-1.6.1.0-1MzVHlnKwiQv2u5S9KxgB
    yesod-test-1.6.16-9TCoLoyFa2Y3jFx76NG5dK

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.2.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

