/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.view.std.JSColorButton;
import org.jsampler.view.std.JSLSConsolePane;
import org.jsampler.view.std.StdI18n;

public class JSLSConsolePropsPane
extends JPanel {
    private final JCheckBox checkSaveCmdHist = new JCheckBox(StdI18n.i18n.getLabel("JSLSConsolePropsPane.checkSaveCmdHist"));
    private final JLabel lCmdHistorySize = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lCmdHistorySize"));
    private JSpinner spCmdHistorySize;
    private final JLabel lLines = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lLines"));
    private final JButton btnClearCmdHistory = new JButton(StdI18n.i18n.getButtonLabel("JSLSConsolePropsPane.btnClearCmdHistory"));
    private final JLabel lTextColor = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lTextColor"));
    private final JSColorButton btnTextColor = new JSColorButton();
    private final JLabel lBGColor = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lBGColor"));
    private final JSColorButton btnBGColor = new JSColorButton();
    private final JLabel lNotifyColor = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lNotifyColor"));
    private final JSColorButton btnNotifyColor = new JSColorButton();
    private final JLabel lWarningColor = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lWarningColor"));
    private final JSColorButton btnWarningColor = new JSColorButton();
    private final JLabel lErrorColor = new JLabel(StdI18n.i18n.getLabel("JSLSConsolePropsPane.lErrorColor"));
    private final JSColorButton btnErrorColor = new JSColorButton();

    public JSLSConsolePropsPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.checkSaveCmdHist);
        this.add(this.createCommandHistoryPane());
        this.add(Box.createRigidArea(new Dimension(0, 6)));
        this.add(this.createConsoleColorsPane());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
    }

    private JPanel createCommandHistoryPane() {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = this.preferences().getIntProperty("LSConsole.historySize", 1000);
        this.spCmdHistorySize = new JSpinner(new SpinnerNumberModel(n, 0, 20000, 1));
        this.spCmdHistorySize.setMaximumSize(this.spCmdHistorySize.getPreferredSize());
        this.btnClearCmdHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLSConsolePane.clearConsoleHistory();
                JSLSConsolePropsPane.this.clearConsoleHistory();
            }
        });
        this.btnClearCmdHistory.setAlignmentX(0.5f);
        this.add(this.btnClearCmdHistory);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 6, 3, 0);
        gridBagLayout.setConstraints(this.lCmdHistorySize, gridBagConstraints);
        jPanel.add(this.lCmdHistorySize);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.spCmdHistorySize, gridBagConstraints);
        jPanel.add(this.spCmdHistorySize);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.lLines, gridBagConstraints);
        jPanel.add(this.lLines);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 12, 3, 6);
        gridBagLayout.setConstraints(this.btnClearCmdHistory, gridBagConstraints);
        jPanel.add(this.btnClearCmdHistory);
        this.checkSaveCmdHist.setSelected(this.preferences().getBoolProperty("LSConsole.saveCommandHistory"));
        this.checkSaveCmdHist.setAlignmentX(0.5f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(3, 6, 3, 6);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.checkSaveCmdHist, gridBagConstraints);
        jPanel.add(this.checkSaveCmdHist);
        String string = StdI18n.i18n.getLabel("JSLSConsolePropsPane.commandHistory");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        return jPanel;
    }

    private JPanel createConsoleColorsPane() {
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.5f);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lTextColor, gridBagConstraints);
        jPanel.add(this.lTextColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lBGColor, gridBagConstraints);
        jPanel.add(this.lBGColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lNotifyColor, gridBagConstraints);
        jPanel.add(this.lNotifyColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.lWarningColor, gridBagConstraints);
        jPanel.add(this.lWarningColor);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.lErrorColor, gridBagConstraints);
        jPanel.add(this.lErrorColor);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.btnTextColor, gridBagConstraints);
        jPanel.add(this.btnTextColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.btnBGColor, gridBagConstraints);
        jPanel.add(this.btnBGColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.btnNotifyColor, gridBagConstraints);
        jPanel.add(this.btnNotifyColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.btnWarningColor, gridBagConstraints);
        jPanel.add(this.btnWarningColor);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.btnErrorColor, gridBagConstraints);
        jPanel.add(this.btnErrorColor);
        int n = this.preferences().getIntProperty("LSConsole.textColor");
        this.btnTextColor.setColor(new Color(n));
        n = this.preferences().getIntProperty("LSConsole.backgroundColor");
        this.btnBGColor.setColor(new Color(n));
        n = this.preferences().getIntProperty("LSConsole.notifyColor");
        this.btnNotifyColor.setColor(new Color(n));
        n = this.preferences().getIntProperty("LSConsole.warningColor");
        this.btnWarningColor.setColor(new Color(n));
        n = this.preferences().getIntProperty("LSConsole.errorColor");
        this.btnErrorColor.setColor(new Color(n));
        String string = StdI18n.i18n.getButtonLabel("JSLSConsolePropsPane.btnDefaults");
        JButton jButton = new JButton(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JSLSConsolePropsPane.this.preferences().getDefaultIntValue("LSConsole.textColor");
                JSLSConsolePropsPane.this.preferences().setIntProperty("LSConsole.textColor", n);
                JSLSConsolePropsPane.this.btnTextColor.setColor(new Color(n));
                n = JSLSConsolePropsPane.this.preferences().getDefaultIntValue("LSConsole.backgroundColor");
                JSLSConsolePropsPane.this.preferences().setIntProperty("LSConsole.backgroundColor", n);
                JSLSConsolePropsPane.this.btnBGColor.setColor(new Color(n));
                n = JSLSConsolePropsPane.this.preferences().getDefaultIntValue("LSConsole.notifyColor");
                JSLSConsolePropsPane.this.preferences().setIntProperty("LSConsole.notifyColor", n);
                JSLSConsolePropsPane.this.btnNotifyColor.setColor(new Color(n));
                n = JSLSConsolePropsPane.this.preferences().getDefaultIntValue("LSConsole.warningColor");
                JSLSConsolePropsPane.this.preferences().setIntProperty("LSConsole.warningColor", n);
                JSLSConsolePropsPane.this.btnWarningColor.setColor(new Color(n));
                n = JSLSConsolePropsPane.this.preferences().getDefaultIntValue("LSConsole.errorColor");
                JSLSConsolePropsPane.this.preferences().setIntProperty("LSConsole.errorColor", n);
                JSLSConsolePropsPane.this.btnErrorColor.setColor(new Color(n));
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 6));
        jPanel2.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        jPanel2.add(Box.createGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createGlue());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        string = StdI18n.i18n.getLabel("JSLSConsolePropsPane.consoleColors");
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        return jPanel;
    }

    private JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    protected void clearConsoleHistory() {
    }

    protected void apply() {
        boolean bl = this.checkSaveCmdHist.isSelected();
        this.preferences().setBoolProperty("LSConsole.saveCommandHistory", bl);
        int n = Integer.parseInt(this.spCmdHistorySize.getValue().toString());
        this.preferences().setIntProperty("LSConsole.historySize", n);
        int n2 = this.btnTextColor.getColor().getRGB();
        this.preferences().setIntProperty("LSConsole.textColor", n2);
        n2 = this.btnBGColor.getColor().getRGB();
        this.preferences().setIntProperty("LSConsole.backgroundColor", n2);
        n2 = this.btnNotifyColor.getColor().getRGB();
        this.preferences().setIntProperty("LSConsole.notifyColor", n2);
        n2 = this.btnWarningColor.getColor().getRGB();
        this.preferences().setIntProperty("LSConsole.warningColor", n2);
        n2 = this.btnErrorColor.getColor().getRGB();
        this.preferences().setIntProperty("LSConsole.errorColor", n2);
    }
}

