/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.WriteTxnMarkersRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public class WriteTxnMarkersRequest
extends AbstractRequest {
    private final WriteTxnMarkersRequestData data;

    private WriteTxnMarkersRequest(WriteTxnMarkersRequestData data, short version) {
        super(ApiKeys.WRITE_TXN_MARKERS, version);
        this.data = data;
    }

    @Override
    public WriteTxnMarkersRequestData data() {
        return this.data;
    }

    @Override
    public WriteTxnMarkersResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>(this.data.markers().size());
        for (WriteTxnMarkersRequestData.WritableTxnMarker markerEntry : this.data.markers()) {
            HashMap<TopicPartition, Errors> errorsPerPartition = new HashMap<TopicPartition, Errors>();
            for (WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic : markerEntry.topics()) {
                for (Integer partitionIdx : topic.partitionIndexes()) {
                    errorsPerPartition.put(new TopicPartition(topic.name(), partitionIdx), error);
                }
            }
            errors.put(markerEntry.producerId(), errorsPerPartition);
        }
        return new WriteTxnMarkersResponse(errors);
    }

    public List<TxnMarkerEntry> markers() {
        ArrayList<TxnMarkerEntry> markers = new ArrayList<TxnMarkerEntry>();
        for (WriteTxnMarkersRequestData.WritableTxnMarker markerEntry : this.data.markers()) {
            ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
            for (WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic : markerEntry.topics()) {
                for (Integer partitionIdx : topic.partitionIndexes()) {
                    topicPartitions.add(new TopicPartition(topic.name(), partitionIdx));
                }
            }
            markers.add(new TxnMarkerEntry(markerEntry.producerId(), markerEntry.producerEpoch(), markerEntry.coordinatorEpoch(), TransactionResult.forId(markerEntry.transactionResult()), topicPartitions));
        }
        return markers;
    }

    public static WriteTxnMarkersRequest parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersRequest(new WriteTxnMarkersRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTxnMarkersRequest that = (WriteTxnMarkersRequest)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public static class TxnMarkerEntry {
        private final long producerId;
        private final short producerEpoch;
        private final int coordinatorEpoch;
        private final TransactionResult result;
        private final List<TopicPartition> partitions;

        public TxnMarkerEntry(long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, List<TopicPartition> partitions) {
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.coordinatorEpoch = coordinatorEpoch;
            this.result = result;
            this.partitions = partitions;
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        public TransactionResult transactionResult() {
            return this.result;
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public String toString() {
            return "TxnMarkerEntry{producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", coordinatorEpoch=" + this.coordinatorEpoch + ", result=" + (Object)((Object)this.result) + ", partitions=" + this.partitions + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TxnMarkerEntry that = (TxnMarkerEntry)o;
            return this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.coordinatorEpoch == that.coordinatorEpoch && this.result == that.result && Objects.equals(this.partitions, that.partitions);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.producerId, this.producerEpoch, this.coordinatorEpoch, this.result, this.partitions});
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<WriteTxnMarkersRequest> {
        public final WriteTxnMarkersRequestData data;

        public Builder(WriteTxnMarkersRequestData data) {
            super(ApiKeys.WRITE_TXN_MARKERS);
            this.data = data;
        }

        public Builder(short version, List<TxnMarkerEntry> markers) {
            super(ApiKeys.WRITE_TXN_MARKERS, version);
            ArrayList<WriteTxnMarkersRequestData.WritableTxnMarker> dataMarkers = new ArrayList<WriteTxnMarkersRequestData.WritableTxnMarker>();
            for (TxnMarkerEntry marker : markers) {
                HashMap<String, WriteTxnMarkersRequestData.WritableTxnMarkerTopic> topicMap = new HashMap<String, WriteTxnMarkersRequestData.WritableTxnMarkerTopic>();
                for (TopicPartition topicPartition : marker.partitions) {
                    WriteTxnMarkersRequestData.WritableTxnMarkerTopic topic = topicMap.getOrDefault(topicPartition.topic(), new WriteTxnMarkersRequestData.WritableTxnMarkerTopic().setName(topicPartition.topic()));
                    topic.partitionIndexes().add(topicPartition.partition());
                    topicMap.put(topicPartition.topic(), topic);
                }
                dataMarkers.add(new WriteTxnMarkersRequestData.WritableTxnMarker().setProducerId(marker.producerId).setProducerEpoch(marker.producerEpoch).setCoordinatorEpoch(marker.coordinatorEpoch).setTransactionResult(marker.transactionResult().id).setTopics(new ArrayList<WriteTxnMarkersRequestData.WritableTxnMarkerTopic>(topicMap.values())));
            }
            this.data = new WriteTxnMarkersRequestData().setMarkers(dataMarkers);
        }

        @Override
        public WriteTxnMarkersRequest build(short version) {
            return new WriteTxnMarkersRequest(this.data, version);
        }
    }
}

