/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanMultiSiteLoadBalancerCheckProvider;
import org.keycloak.health.LoadBalancerCheckProvider;
import org.keycloak.health.LoadBalancerCheckProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class InfinispanMultiSiteLoadBalancerCheckProviderFactory
implements LoadBalancerCheckProviderFactory,
EnvironmentDependentProviderFactory {
    private LoadBalancerCheckProvider loadBalancerCheckProvider;
    private static final LoadBalancerCheckProvider ALWAYS_HEALTHY = new LoadBalancerCheckProvider(){

        public boolean isDown() {
            return false;
        }

        public void close() {
        }
    };
    private static final Logger LOG = Logger.getLogger(InfinispanMultiSiteLoadBalancerCheckProviderFactory.class);

    public LoadBalancerCheckProvider create(KeycloakSession session) {
        if (this.loadBalancerCheckProvider == null) {
            InfinispanConnectionProvider infinispanConnectionProvider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
            if (infinispanConnectionProvider == null) {
                LOG.warn((Object)"InfinispanConnectionProvider is not available. Load balancer check will be always healthy for Infinispan.");
                this.loadBalancerCheckProvider = ALWAYS_HEALTHY;
            } else {
                this.loadBalancerCheckProvider = new InfinispanMultiSiteLoadBalancerCheckProvider(infinispanConnectionProvider);
            }
        }
        return this.loadBalancerCheckProvider;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan-multisite";
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MULTI_SITE);
    }
}

