/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Environment;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.UserSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.PersistentUserSessionProvider;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionsWorker;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SerializeExecutionsByKey;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanCacheInitializer;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionListener;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoader;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.models.utils.ResetTimeOffsetEvent;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;
import org.keycloak.provider.ServerInfoAwareProviderFactory;

public class InfinispanUserSessionProviderFactory
implements UserSessionProviderFactory,
ServerInfoAwareProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String REMOVE_USER_SESSIONS_EVENT = "REMOVE_USER_SESSIONS_EVENT";
    public static final String CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineSessionCacheEntryLifespanOverride";
    public static final String CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE = "offlineClientSessionCacheEntryLifespanOverride";
    public static final String CONFIG_MAX_BATCH_SIZE = "maxBatchSize";
    public static final int DEFAULT_MAX_BATCH_SIZE = Math.max(Runtime.getRuntime().availableProcessors(), 2);
    private long offlineSessionCacheEntryLifespanOverride;
    private long offlineClientSessionCacheEntryLifespanOverride;
    private Config.Scope config;
    private RemoteCacheInvoker remoteCacheInvoker;
    private CrossDCLastSessionRefreshStore lastSessionRefreshStore;
    private CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore;
    private PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    private InfinispanKeyGenerator keyGenerator;
    SerializeExecutionsByKey<String> serializerSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<String> serializerOfflineSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<UUID> serializerClientSession = new SerializeExecutionsByKey();
    SerializeExecutionsByKey<UUID> serializerOfflineClientSession = new SerializeExecutionsByKey();
    ArrayBlockingQueue<PersistentUpdate> asyncQueuePersistentUpdate = new ArrayBlockingQueue(1000);
    private PersistentSessionsWorker persistentSessionsWorker;
    private int maxBatchSize;

    public UserSessionProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("sessions");
        Cache offlineSessionsCache = connections.getCache("offlineSessions");
        Cache clientSessionCache = connections.getCache("clientSessions");
        Cache offlineClientSessionsCache = connections.getCache("offlineClientSessions");
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            return new PersistentUserSessionProvider(session, this.remoteCacheInvoker, this.lastSessionRefreshStore, this.offlineLastSessionRefreshStore, this.keyGenerator, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, this.asyncQueuePersistentUpdate, this.serializerSession, this.serializerOfflineSession, this.serializerClientSession, this.serializerOfflineClientSession);
        }
        return new InfinispanUserSessionProvider(session, this.remoteCacheInvoker, this.lastSessionRefreshStore, this.offlineLastSessionRefreshStore, this.persisterLastSessionRefreshStore, this.keyGenerator, cache, offlineSessionsCache, clientSessionCache, offlineClientSessionsCache, this::deriveOfflineSessionCacheEntryLifespanMs, this::deriveOfflineClientSessionCacheEntryLifespanOverrideMs, this.serializerSession, this.serializerOfflineSession, this.serializerClientSession, this.serializerOfflineClientSession);
    }

    public void init(Config.Scope config) {
        this.config = config;
        this.offlineSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        this.offlineClientSessionCacheEntryLifespanOverride = config.getInt(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Integer.valueOf(-1)).intValue();
        this.maxBatchSize = config.getInt(CONFIG_MAX_BATCH_SIZE, Integer.valueOf(DEFAULT_MAX_BATCH_SIZE));
    }

    public void postInit(final KeycloakSessionFactory factory) {
        factory.register(new ProviderEventListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onEvent(ProviderEvent event) {
                if (event instanceof PostMigrationEvent) {
                    int preloadTransactionTimeout = InfinispanUserSessionProviderFactory.this.getTimeoutForPreloadingSessionsSeconds();
                    log.debugf("Will preload sessions with transaction timeout %d seconds", preloadTransactionTimeout);
                    KeycloakModelUtils.runJobInTransactionWithTimeout((KeycloakSessionFactory)factory, session -> {
                        InfinispanUserSessionProviderFactory.this.keyGenerator = new InfinispanKeyGenerator();
                        InfinispanUserSessionProviderFactory.this.checkRemoteCaches(session);
                        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
                            InfinispanUserSessionProviderFactory.this.initializeLastSessionRefreshStore(factory);
                        }
                        InfinispanUserSessionProviderFactory.this.registerClusterListeners(session);
                        InfinispanUserSessionProviderFactory.this.loadSessionsFromRemoteCaches(session);
                    }, (int)preloadTransactionTimeout);
                    return;
                } else if (event instanceof UserModel.UserRemovedEvent) {
                    UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                    UserSessionProvider provider1 = (UserSessionProvider)userRemovedEvent.getKeycloakSession().getProvider(UserSessionProvider.class, InfinispanUserSessionProviderFactory.this.getId());
                    if (provider1 instanceof InfinispanUserSessionProvider) {
                        ((InfinispanUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                        return;
                    } else {
                        if (!(provider1 instanceof PersistentUserSessionProvider)) throw new IllegalStateException("Unknown provider type: " + String.valueOf(provider1.getClass()));
                        ((PersistentUserSessionProvider)provider1).onUserRemoved(userRemovedEvent.getRealm(), userRemovedEvent.getUser());
                    }
                    return;
                } else {
                    if (!(event instanceof ResetTimeOffsetEvent)) return;
                    if (InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore != null) {
                        InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore.reset();
                    }
                    if (InfinispanUserSessionProviderFactory.this.lastSessionRefreshStore != null) {
                        InfinispanUserSessionProviderFactory.this.lastSessionRefreshStore.reset();
                    }
                    if (InfinispanUserSessionProviderFactory.this.offlineLastSessionRefreshStore == null) return;
                    InfinispanUserSessionProviderFactory.this.offlineLastSessionRefreshStore.reset();
                }
            }
        });
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            this.persistentSessionsWorker = new PersistentSessionsWorker(factory, this.asyncQueuePersistentUpdate, this.maxBatchSize);
            this.persistentSessionsWorker.start();
        }
    }

    private int getMaxErrors() {
        return this.config.getInt("maxErrors", Integer.valueOf(20));
    }

    private int getSessionsPerSegment() {
        return this.config.getInt("sessionsPerSegment", Integer.valueOf(64));
    }

    private int getTimeoutForPreloadingSessionsSeconds() {
        Integer timeout = this.config.getInt("sessionsPreloadTimeoutInSeconds", null);
        return timeout != null ? timeout : Environment.getServerStartupTimeout();
    }

    private int getStalledTimeoutInSeconds(int defaultTimeout) {
        return this.config.getInt("sessionPreloadStalledTimeoutInSeconds", Integer.valueOf(defaultTimeout));
    }

    public void initializeLastSessionRefreshStore(KeycloakSessionFactory sessionFactory) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanUserSessionProviderFactory.this.persisterLastSessionRefreshStore = new PersisterLastSessionRefreshStoreFactory().createAndInit(session, true);
            }
        });
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRealmRemovedEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(REMOVE_USER_SESSIONS_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveUserSessionsEvent, UserSessionProvider>(sessionFactory, UserSessionProvider.class){

            @Override
            protected void eventReceived(UserSessionProvider provider, RemoveUserSessionsEvent sessionEvent) {
                if (provider instanceof InfinispanUserSessionProvider) {
                    ((InfinispanUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                } else if (provider instanceof PersistentUserSessionProvider) {
                    ((PersistentUserSessionProvider)provider).onRemoveUserSessionsEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected void checkRemoteCaches(KeycloakSession session) {
        this.remoteCacheInvoker = new RemoteCacheInvoker();
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache sessionsCache = ispn.getCache("sessions");
        RemoteCache sessionsRemoteCache = this.checkRemoteCache(session, sessionsCache, realm -> Time.toMillis((long)realm.getSsoSessionMaxLifespan()), SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs);
        if (sessionsRemoteCache != null) {
            this.lastSessionRefreshStore = new CrossDCLastSessionRefreshStoreFactory().createAndInit(session, sessionsCache, false);
        }
        Cache clientSessionsCache = ispn.getCache("clientSessions");
        this.checkRemoteCache(session, clientSessionsCache, realm -> Time.toMillis((long)realm.getSsoSessionMaxLifespan()), SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
        Cache offlineSessionsCache = ispn.getCache("offlineSessions");
        RemoteCache offlineSessionsRemoteCache = this.checkRemoteCache(session, offlineSessionsCache, realm -> Time.toMillis((long)realm.getOfflineSessionIdleTimeout()), this::deriveOfflineSessionCacheEntryLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
        if (offlineSessionsRemoteCache != null) {
            this.offlineLastSessionRefreshStore = new CrossDCLastSessionRefreshStoreFactory().createAndInit(session, offlineSessionsCache, true);
        }
        Cache offlineClientSessionsCache = ispn.getCache("offlineClientSessions");
        this.checkRemoteCache(session, offlineClientSessionsCache, realm -> Time.toMillis((long)realm.getOfflineSessionIdleTimeout()), this::deriveOfflineClientSessionCacheEntryLifespanOverrideMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
    }

    private <K, V extends SessionEntity> RemoteCache checkRemoteCache(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> ispnCache, RemoteCacheInvoker.MaxIdleTimeLoader maxIdleLoader, SessionFunction<V> lifespanMsLoader, SessionFunction<V> maxIdleTimeMsLoader) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            log.debugf("No remote store configured for cache '%s'", (Object)ispnCache.getName());
            return null;
        }
        log.infof("Remote store configured for cache '%s'", (Object)ispnCache.getName());
        RemoteCache remoteCache = remoteStores.iterator().next().getRemoteCache();
        if (remoteCache == null) {
            throw new IllegalStateException("No remote cache available for the infinispan cache: " + ispnCache.getName());
        }
        this.remoteCacheInvoker.addRemoteCache(ispnCache.getName(), remoteCache, maxIdleLoader);
        Runnable onFailover = null;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
            onFailover = () -> ispnCache.clear();
        }
        RemoteCacheSessionListener hotrodListener = RemoteCacheSessionListener.createListener(session, ispnCache, remoteCache, lifespanMsLoader, maxIdleTimeMsLoader, onFailover);
        remoteCache.addClientListener((Object)hotrodListener);
        return remoteCache;
    }

    protected Long deriveOfflineSessionCacheEntryLifespanMs(RealmModel realm, ClientModel client, UserSessionEntity entity) {
        long configuredOfflineSessionLifespan = SessionTimeouts.getOfflineSessionLifespanMs(realm, client, entity);
        if (this.offlineSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineSessionLifespan;
        }
        if (configuredOfflineSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineSessionCacheEntryLifespanOverride), configuredOfflineSessionLifespan);
    }

    protected Long deriveOfflineClientSessionCacheEntryLifespanOverrideMs(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity entity) {
        long configuredOfflineClientSessionLifespan = SessionTimeouts.getOfflineClientSessionLifespanMs(realm, client, entity);
        if (this.offlineClientSessionCacheEntryLifespanOverride == -1L) {
            return configuredOfflineClientSessionLifespan;
        }
        if (configuredOfflineClientSessionLifespan == -1L) {
            return TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride);
        }
        return Math.min(TimeUnit.SECONDS.toMillis(this.offlineClientSessionCacheEntryLifespanOverride), configuredOfflineClientSessionLifespan);
    }

    private void loadSessionsFromRemoteCaches(KeycloakSession session) {
        for (String cacheName : this.remoteCacheInvoker.getRemoteCacheNames()) {
            this.loadSessionsFromRemoteCache(session.getKeycloakSessionFactory(), cacheName, this.getSessionsPerSegment(), this.getMaxErrors());
        }
    }

    private void loadSessionsFromRemoteCache(final KeycloakSessionFactory sessionFactory, final String cacheName, final int sessionsPerSegment, final int maxErrors) {
        log.debugf("Check pre-loading sessions from remote cache '%s'", (Object)cacheName);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache workCache = connections.getCache("work");
                int defaultStateTransferTimeout = (int)(connections.getCache("sessions").getCacheConfiguration().clustering().stateTransfer().timeout() / 1000L);
                InfinispanCacheInitializer initializer = new InfinispanCacheInitializer(sessionFactory, workCache, new RemoteCacheSessionsLoader(cacheName, sessionsPerSegment), "remoteCacheLoad::" + cacheName, maxErrors, InfinispanUserSessionProviderFactory.this.getStalledTimeoutInSeconds(defaultStateTransferTimeout));
                initializer.loadSessions();
            }
        });
        log.debugf("Pre-loading sessions from remote cache '%s' finished", (Object)cacheName);
    }

    public void close() {
        if (this.persistentSessionsWorker != null) {
            this.persistentSessionsWorker.stop();
        }
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public int order() {
        return 1;
    }

    public Map<String, String> getOperationalInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineSessionCacheEntryLifespanOverride));
        info.put(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE, Long.toString(this.offlineClientSessionCacheEntryLifespanOverride));
        info.put(CONFIG_MAX_BATCH_SIZE, Integer.toString(this.maxBatchSize));
        return info;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        builder.property().name(CONFIG_MAX_BATCH_SIZE).type("int").helpText("Maximum size of a batch size (only applicable to persistent sessions").defaultValue((Object)DEFAULT_MAX_BATCH_SIZE).add();
        builder.property().name(CONFIG_OFFLINE_CLIENT_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline client sessions should be kept in memory").add();
        builder.property().name(CONFIG_OFFLINE_SESSION_CACHE_ENTRY_LIFESPAN_OVERRIDE).type("int").helpText("Override how long offline user sessions should be kept in memory").add();
        return builder.build();
    }
}

