/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cookie;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.cookie.CookiePathResolver;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieSecureResolver;
import org.keycloak.cookie.CookieType;
import org.keycloak.models.KeycloakContext;

public class DefaultCookieProvider
implements CookieProvider {
    private static final Logger logger = Logger.getLogger(DefaultCookieProvider.class);
    private final KeycloakContext context;
    private CookiePathResolver pathResolver;
    private CookieSecureResolver secureResolver;
    private final Map<String, Cookie> cookies;
    private final boolean sameSiteLegacyEnabled;

    public DefaultCookieProvider(KeycloakContext context, boolean sameSiteLegacyEnabled) {
        this.context = context;
        this.cookies = context.getRequestHeaders().getCookies();
        this.pathResolver = new CookiePathResolver(context);
        this.secureResolver = new CookieSecureResolver(context, sameSiteLegacyEnabled);
        this.sameSiteLegacyEnabled = sameSiteLegacyEnabled;
        if (logger.isTraceEnabled()) {
            String cookieNames = String.join((CharSequence)", ", this.cookies.keySet());
            logger.tracef("Path: %s, cookies: %s", (Object)context.getUri().getRequestUri().getRawPath(), (Object)cookieNames);
        }
    }

    public void set(CookieType cookieType, String value) {
        if (cookieType.getDefaultMaxAge() == null) {
            throw new IllegalArgumentException(String.valueOf(cookieType) + " has no default max-age");
        }
        this.set(cookieType, value, cookieType.getDefaultMaxAge());
    }

    public void set(CookieType cookieType, String value, int maxAge) {
        String name = cookieType.getName();
        NewCookie.SameSite sameSite = cookieType.getScope().getSameSite();
        boolean secure = this.secureResolver.resolveSecure(sameSite);
        String path = this.pathResolver.resolvePath(cookieType);
        boolean httpOnly = cookieType.getScope().isHttpOnly();
        NewCookie newCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(name).version(1)).value(value)).path(path)).maxAge(maxAge)).secure(secure)).httpOnly(httpOnly)).sameSite(sameSite)).build();
        this.context.getHttpResponse().setCookieIfAbsent(newCookie);
        logger.tracef("Setting cookie: name: %s, path: %s, same-site: %s, secure: %s, http-only: %s, max-age: %d", new Object[]{name, path, sameSite, secure, httpOnly, maxAge});
        this.setSameSiteLegacy(cookieType, value, maxAge);
    }

    private void setSameSiteLegacy(CookieType cookieType, String value, int maxAge) {
        if (this.sameSiteLegacyEnabled && cookieType.supportsSameSiteLegacy()) {
            String legacyName = cookieType.getSameSiteLegacyName();
            boolean legacySecure = this.secureResolver.resolveSecure(null);
            String path = this.pathResolver.resolvePath(cookieType);
            boolean httpOnly = cookieType.getScope().isHttpOnly();
            NewCookie legacyCookie = ((NewCookie.Builder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(legacyName).version(1)).value(value)).maxAge(maxAge)).path(path)).secure(legacySecure)).httpOnly(httpOnly)).build();
            this.context.getHttpResponse().setCookieIfAbsent(legacyCookie);
            logger.tracef("Setting legacy cookie: name: %s, path: %s, same-site: %s, secure: %s, http-only: %s, max-age: %d", new Object[]{legacyName, path, null, legacySecure, httpOnly, maxAge});
        } else if (cookieType.supportsSameSiteLegacy()) {
            this.expireSameSiteLegacy(cookieType);
        }
    }

    public String get(CookieType cookieType) {
        Cookie cookie = this.cookies.get(cookieType.getName());
        if (cookie == null) {
            cookie = this.getSameSiteLegacyCookie(cookieType);
        }
        return cookie != null ? cookie.getValue() : null;
    }

    private Cookie getSameSiteLegacyCookie(CookieType cookieType) {
        if (cookieType.supportsSameSiteLegacy()) {
            return this.cookies.get(cookieType.getSameSiteLegacyName());
        }
        return null;
    }

    public void expire(CookieType cookieType) {
        this.expire(cookieType.getName(), cookieType);
        this.expireSameSiteLegacy(cookieType);
    }

    private void expireSameSiteLegacy(CookieType cookieType) {
        if (cookieType.supportsSameSiteLegacy()) {
            this.expire(cookieType.getSameSiteLegacyName(), cookieType);
        }
    }

    private void expire(String cookieName, CookieType cookieType) {
        Cookie cookie = this.cookies.get(cookieName);
        if (cookie != null) {
            String path = this.pathResolver.resolvePath(cookieType);
            NewCookie newCookie = ((NewCookie.Builder)((NewCookie.AbstractNewCookieBuilder)((NewCookie.AbstractNewCookieBuilder)new NewCookie.Builder(cookieName).version(1)).path(path)).maxAge(0)).build();
            this.context.getHttpResponse().setCookieIfAbsent(newCookie);
            logger.tracef("Expiring cookie: name: %s, path: %s", (Object)cookie.getName(), (Object)path);
        }
    }

    public void close() {
    }
}

