/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.admin.resource.OrganizationResource;
import org.keycloak.organization.utils.Organizations;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.utils.SearchQueryUtils;
import org.keycloak.utils.StringUtil;

@Provider
@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationsResource {
    private final KeycloakSession session;
    private final OrganizationProvider provider;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public OrganizationsResource() {
        this(null, null, null);
    }

    public OrganizationsResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.provider = session == null ? null : (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.auth = auth;
        this.adminEvent = adminEvent;
    }

    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Creates a new organization")
    public Response create(OrganizationRepresentation organization) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (organization == null) {
            throw ErrorResponse.error("Organization cannot be null.", Response.Status.BAD_REQUEST);
        }
        try {
            OrganizationModel model = this.provider.create(organization.getName());
            Organizations.toModel(organization, model);
            return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
        }
        catch (ModelValidationException mve) {
            throw ErrorResponse.error(mve.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Organizations")
    @Operation(summary="Returns a paginated list of organizations filtered according to the specified parameters")
    public Stream<OrganizationRepresentation> search(@Parameter(description="A String representing either an organization name or domain") @QueryParam(value="search") String search, @Parameter(description="A query to search for custom attributes, in the format 'key1:value2 key2:value2'") @QueryParam(value="q") String searchQuery, @Parameter(description="Boolean which defines whether the param 'search' must match exactly or not") @QueryParam(value="exact") Boolean exact, @Parameter(description="The position of the first result to be processed (pagination offset)") @QueryParam(value="first") @DefaultValue(value="0") Integer first, @Parameter(description="The maximum number of results to be returned - defaults to 10") @QueryParam(value="max") @DefaultValue(value="10") Integer max) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (StringUtil.isNotBlank((String)searchQuery)) {
            Map<String, String> attributes = SearchQueryUtils.getFields(searchQuery);
            return this.provider.getAllStream(attributes, first, max).map(Organizations::toRepresentation);
        }
        return this.provider.getAllStream(search, exact, first, max).map(Organizations::toRepresentation);
    }

    @Path(value="{id}")
    public OrganizationResource get(@PathParam(value="id") String id) {
        this.auth.realm().requireManageRealm();
        Organizations.checkEnabled(this.provider);
        if (StringUtil.isBlank((String)id)) {
            throw ErrorResponse.error("Id cannot be null.", Response.Status.BAD_REQUEST);
        }
        OrganizationModel organizationModel = this.provider.getById(id);
        if (organizationModel == null) {
            throw ErrorResponse.error("Organization not found.", Response.Status.NOT_FOUND);
        }
        this.session.setAttribute(OrganizationModel.class.getName(), (Object)organizationModel);
        return new OrganizationResource(this.session, organizationModel, this.adminEvent);
    }
}

