/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.OID4VCClientRegistrationProvider;
import org.keycloak.protocol.oid4vc.issuance.OID4VCIssuerWellKnownProvider;
import org.keycloak.protocol.oid4vc.issuance.TimeProvider;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialOfferURI;
import org.keycloak.protocol.oid4vc.model.CredentialRequest;
import org.keycloak.protocol.oid4vc.model.CredentialResponse;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oid4vc.model.ErrorResponse;
import org.keycloak.protocol.oid4vc.model.ErrorType;
import org.keycloak.protocol.oid4vc.model.Format;
import org.keycloak.protocol.oid4vc.model.OID4VCClient;
import org.keycloak.protocol.oid4vc.model.OfferUriType;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedCode;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;
import org.keycloak.protocol.oid4vc.model.SupportedCredentialConfiguration;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.protocol.oidc.grants.PreAuthorizedCodeGrantType;
import org.keycloak.provider.Provider;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;

public class OID4VCIssuerEndpoint {
    private static final Logger LOGGER = Logger.getLogger(OID4VCIssuerEndpoint.class);
    public static final String CREDENTIAL_PATH = "credential";
    public static final String CREDENTIAL_OFFER_PATH = "credential-offer/";
    public static final String RESPONSE_TYPE_IMG_PNG = "image/png";
    private final KeycloakSession session;
    private final AppAuthManager.BearerTokenAuthenticator bearerTokenAuthenticator;
    private final ObjectMapper objectMapper;
    private final TimeProvider timeProvider;
    private final String issuerDid;
    private final int preAuthorizedCodeLifeSpan;
    private final Map<Format, VerifiableCredentialsSigningService> signingServices;

    public OID4VCIssuerEndpoint(KeycloakSession session, String issuerDid, Map<Format, VerifiableCredentialsSigningService> signingServices, AppAuthManager.BearerTokenAuthenticator authenticator, ObjectMapper objectMapper, TimeProvider timeProvider, int preAuthorizedCodeLifeSpan) {
        this.session = session;
        this.bearerTokenAuthenticator = authenticator;
        this.objectMapper = objectMapper;
        this.timeProvider = timeProvider;
        this.issuerDid = issuerDid;
        this.signingServices = signingServices;
        this.preAuthorizedCodeLifeSpan = preAuthorizedCodeLifeSpan;
    }

    @GET
    @Produces(value={"application/json", "image/png"})
    @Path(value="credential-offer-uri")
    public Response getCredentialOfferURI(@QueryParam(value="credential_configuration_id") String vcId, @QueryParam(value="type") @DefaultValue(value="uri") OfferUriType type, @QueryParam(value="width") @DefaultValue(value="200") int width, @QueryParam(value="height") @DefaultValue(value="200") int height) {
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        Map<String, SupportedCredentialConfiguration> credentialsMap = OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session);
        LOGGER.debugf("Get an offer for %s", (Object)vcId);
        if (!credentialsMap.containsKey(vcId)) {
            LOGGER.debugf("No credential with id %s exists.", (Object)vcId);
            LOGGER.debugf("Supported credentials are %s.", credentialsMap);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        SupportedCredentialConfiguration supportedCredentialConfiguration = credentialsMap.get(vcId);
        Format format = supportedCredentialConfiguration.getFormat();
        if (this.getClientsOfType(supportedCredentialConfiguration.getScope(), format).isEmpty()) {
            LOGGER.debugf("No OID4VP-Client supporting type %s registered.", (Object)supportedCredentialConfiguration.getScope());
            throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
        }
        String nonce = this.generateNonce();
        try {
            clientSession.setNote(nonce, this.objectMapper.writeValueAsString((Object)supportedCredentialConfiguration));
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert Supported Credential POJO to JSON: %s", (Object)e.getMessage());
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OfferUriType.URI -> this.getOfferUriAsUri(nonce);
            case OfferUriType.QR_CODE -> this.getOfferUriAsQr(nonce, width, height);
        };
    }

    private Response getOfferUriAsUri(String nonce) {
        CredentialOfferURI credentialOfferURI = new CredentialOfferURI().setIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/").setNonce(nonce);
        return Response.ok().type("application/json").entity((Object)credentialOfferURI).build();
    }

    private Response getOfferUriAsQr(String nonce, int width, int height) {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        String endcodedOfferUri = URLEncoder.encode(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext()) + "/protocol/oid4vc/credential-offer/" + nonce, StandardCharsets.UTF_8);
        try {
            BitMatrix bitMatrix = qrCodeWriter.encode("openid-credential-offer://?credential_offer_uri=" + endcodedOfferUri, BarcodeFormat.QR_CODE, width, height);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
            return Response.ok().type(RESPONSE_TYPE_IMG_PNG).entity((Object)bos.toByteArray()).build();
        }
        catch (WriterException | IOException e) {
            LOGGER.warnf("Was not able to create a qr code of dimension %s:%s.", (Object)width, (Object)height, (Object)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Was not able to generate qr.").build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="credential-offer/{nonce}")
    public Response getCredentialOffer(@PathParam(value="nonce") String nonce) {
        SupportedCredentialConfiguration offeredCredential;
        if (nonce == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        AuthenticatedClientSessionModel clientSession = this.getAuthenticatedClientSession();
        String note = clientSession.getNote(nonce);
        if (note == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        try {
            offeredCredential = (SupportedCredentialConfiguration)this.objectMapper.readValue(note, SupportedCredentialConfiguration.class);
            LOGGER.debugf("Creating an offer for %s - %s", (Object)offeredCredential.getScope(), (Object)offeredCredential.getFormat());
            clientSession.removeNote(nonce);
        }
        catch (JsonProcessingException e) {
            LOGGER.errorf("Could not convert SupportedCredential JSON to POJO: %s", (Object)e);
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_CREDENTIAL_REQUEST));
        }
        String preAuthorizedCode = this.generateAuthorizationCodeForClientSession(clientSession);
        CredentialsOffer theOffer = new CredentialsOffer().setCredentialIssuer(OID4VCIssuerWellKnownProvider.getIssuer(this.session.getContext())).setCredentialConfigurationIds(List.of(offeredCredential.getId())).setGrants(new PreAuthorizedGrant().setPreAuthorizedCode(new PreAuthorizedCode().setPreAuthorizedCode(preAuthorizedCode)));
        LOGGER.debugf("Responding with offer: %s", (Object)theOffer);
        return Response.ok().entity((Object)theOffer).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="credential")
    public Response requestCredential(CredentialRequest credentialRequestVO) {
        LOGGER.debugf("Received credentials request %s.", (Object)credentialRequestVO);
        UserSessionModel userSessionModel = this.getUserSessionModel();
        Format requestedFormat = credentialRequestVO.getFormat();
        String requestedCredential = credentialRequestVO.getCredentialIdentifier();
        SupportedCredentialConfiguration supportedCredentialConfiguration = Optional.ofNullable(OID4VCIssuerWellKnownProvider.getSupportedCredentials(this.session).get(requestedCredential)).orElseThrow(() -> {
            LOGGER.debugf("Unsupported credential %s was requested.", (Object)requestedCredential);
            return new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
        });
        if (!supportedCredentialConfiguration.getFormat().equals((Object)requestedFormat)) {
            LOGGER.debugf("Format %s is not supported for credential %s.", (Object)requestedFormat, (Object)requestedCredential);
            throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_FORMAT));
        }
        CredentialResponse responseVO = new CredentialResponse();
        Object theCredential = this.getCredential(userSessionModel, supportedCredentialConfiguration.getScope(), credentialRequestVO.getFormat());
        switch (requestedFormat) {
            case LDP_VC: 
            case JWT_VC: 
            case SD_JWT_VC: {
                responseVO.setCredential(theCredential);
                break;
            }
            default: {
                throw new BadRequestException(this.getErrorResponse(ErrorType.UNSUPPORTED_CREDENTIAL_TYPE));
            }
        }
        return Response.ok().entity((Object)responseVO).build();
    }

    private AuthenticatedClientSessionModel getAuthenticatedClientSession() {
        AuthenticationManager.AuthResult authResult = this.getAuthResult();
        UserSessionModel userSessionModel = authResult.getSession();
        AuthenticatedClientSessionModel clientSession = userSessionModel.getAuthenticatedClientSessionByClient(authResult.getClient().getId());
        if (clientSession == null) {
            throw new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN));
        }
        return clientSession;
    }

    private UserSessionModel getUserSessionModel() {
        return this.getAuthResult((WebApplicationException)new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN))).getSession();
    }

    private AuthenticationManager.AuthResult getAuthResult() {
        return this.getAuthResult((WebApplicationException)new BadRequestException(this.getErrorResponse(ErrorType.INVALID_TOKEN)));
    }

    private AuthenticationManager.AuthResult getAuthResult(WebApplicationException errorResponse) {
        AuthenticationManager.AuthResult authResult = this.bearerTokenAuthenticator.authenticate();
        if (authResult == null) {
            throw errorResponse;
        }
        return authResult;
    }

    private Object getCredential(UserSessionModel userSessionModel, String vcType, Format format) {
        List<OID4VCClient> clients = this.getClientsOfType(vcType, format);
        List<OID4VCMapper> protocolMappers = this.getProtocolMappers(clients).stream().map(pm -> {
            OID4VCMapper mapperFactory;
            ProtocolMapper protocolMapper;
            Provider patt0$temp = this.session.getProvider(ProtocolMapper.class, pm.getProtocolMapper());
            if (patt0$temp instanceof OID4VCMapper && (protocolMapper = (ProtocolMapper)(mapperFactory = (OID4VCMapper)patt0$temp).create(this.session)) instanceof OID4VCMapper) {
                OID4VCMapper oid4VCMapper = (OID4VCMapper)protocolMapper;
                oid4VCMapper.setMapperModel((ProtocolMapperModel)pm);
                return oid4VCMapper;
            }
            LOGGER.warnf("The protocol mapper %s is not an instance of OID4VCMapper.", (Object)pm.getId());
            return null;
        }).filter(Objects::nonNull).toList();
        VerifiableCredential credentialToSign = this.getVCToSign(protocolMappers, vcType, userSessionModel);
        return Optional.ofNullable(this.signingServices.get((Object)format)).map(verifiableCredentialsSigningService -> verifiableCredentialsSigningService.signCredential(credentialToSign)).orElseThrow(() -> new IllegalArgumentException(String.format("Requested format %s is not supported.", new Object[]{format})));
    }

    private List<ProtocolMapperModel> getProtocolMappers(List<OID4VCClient> oid4VCClients) {
        return oid4VCClients.stream().map(OID4VCClient::getClientDid).map(this::getClient).flatMap(ProtocolMapperContainerModel::getProtocolMappersStream).toList();
    }

    private String generateNonce() {
        return SecretGenerator.getInstance().randomString();
    }

    private String generateAuthorizationCodeForClientSession(AuthenticatedClientSessionModel clientSessionModel) {
        int expiration = this.timeProvider.currentTimeSeconds() + this.preAuthorizedCodeLifeSpan;
        return PreAuthorizedCodeGrantType.getPreAuthorizedCode(this.session, clientSessionModel, expiration);
    }

    private Response getErrorResponse(ErrorType errorType) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(errorType);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorResponse).build();
    }

    private List<OID4VCClient> getClientsOfType(String vcType, Format format) {
        LOGGER.debugf("Retrieve all clients of type %s, supporting format %s", (Object)vcType, (Object)format.toString());
        if (Optional.ofNullable(vcType).filter(type -> !type.isEmpty()).isEmpty()) {
            throw new BadRequestException("No VerifiableCredential-Type was provided in the request.");
        }
        return this.getOID4VCClientsFromSession().stream().filter(oid4VCClient -> oid4VCClient.getSupportedVCTypes().stream().anyMatch(supportedCredential -> supportedCredential.getScope().equals(vcType))).toList();
    }

    private ClientModel getClient(String clientId) {
        return this.session.clients().getClientByClientId(this.session.getContext().getRealm(), clientId);
    }

    private List<OID4VCClient> getOID4VCClientsFromSession() {
        return this.session.clients().getClientsStream(this.session.getContext().getRealm()).filter(clientModel -> clientModel.getProtocol() != null).filter(clientModel -> clientModel.getProtocol().equals("oid4vc")).map(clientModel -> OID4VCClientRegistrationProvider.fromClientAttributes(clientModel.getClientId(), clientModel.getAttributes())).toList();
    }

    private VerifiableCredential getVCToSign(List<OID4VCMapper> protocolMappers, String vcType, UserSessionModel userSessionModel) {
        VerifiableCredential vc = new VerifiableCredential().setIssuer(URI.create(this.issuerDid)).setIssuanceDate(Date.from(Instant.ofEpochMilli(this.timeProvider.currentTimeMillis()))).setType(List.of(vcType));
        HashMap<String, Object> subjectClaims = new HashMap<String, Object>();
        protocolMappers.stream().filter(mapper -> mapper.isTypeSupported(vcType)).forEach(mapper -> mapper.setClaimsForSubject(subjectClaims, userSessionModel));
        subjectClaims.forEach((key, value) -> vc.getCredentialSubject().setClaims((String)key, value));
        protocolMappers.stream().filter(mapper -> mapper.isTypeSupported(vcType)).forEach(mapper -> mapper.setClaimsForCredential(vc, userSessionModel));
        LOGGER.debugf("The credential to sign is: %s", (Object)vc);
        return vc;
    }
}

